/*
 * Decompiled with CFR 0.152.
 */
package com.envygames.dimensionalpha.event;

import com.envygames.dimensionalpha.ModBlocks;
import com.envygames.dimensionalpha.block.DimensionAlphaTeleporterBlock;
import com.envygames.dimensionalpha.blockentity.TeleporterBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="dimensionalpha")
public class PortalEvents {
    private static final ResourceKey<Level> ALPHA_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"dimensionalpha:eg_dimension_alpha"));

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock evt) {
        ServerLevel targetLevel;
        ServerLevel dest;
        if (evt.getHand() != InteractionHand.MAIN_HAND || evt.getLevel().isClientSide()) {
            return;
        }
        BlockPos pos = evt.getPos();
        BlockState state = evt.getLevel().getBlockState(pos);
        if (!state.is((Block)ModBlocks.DIMENSION_ALPHA_TELEPORTER.get())) {
            return;
        }
        ServerLevel here = (ServerLevel)evt.getLevel();
        ServerPlayer player = (ServerPlayer)evt.getEntity();
        TeleporterBlockEntity be = (TeleporterBlockEntity)here.getBlockEntity(pos);
        if (be == null) {
            return;
        }
        ServerLevel serverLevel = dest = here.dimension() == ALPHA_KEY ? here.getServer().getLevel(Level.OVERWORLD) : here.getServer().getLevel(ALPHA_KEY);
        if (dest == null) {
            return;
        }
        if (!be.isLinked()) {
            TeleporterBlockEntity destBE;
            BlockPos destPos = dest.dimension() == ALPHA_KEY ? new BlockPos(pos.getX(), 270, pos.getZ()) : PortalEvents.findTopSolidBlock(dest, pos.getX(), pos.getZ());
            BlockState destState = dest.getBlockState(destPos);
            if (!destState.is((Block)ModBlocks.DIMENSION_ALPHA_TELEPORTER.get())) {
                dest.setBlockAndUpdate(destPos, ((DimensionAlphaTeleporterBlock)((Object)ModBlocks.DIMENSION_ALPHA_TELEPORTER.get())).defaultBlockState());
            }
            if ((destBE = (TeleporterBlockEntity)dest.getBlockEntity(destPos)) == null) {
                return;
            }
            be.linkTo((ResourceKey<Level>)dest.dimension(), destPos);
            destBE.linkTo((ResourceKey<Level>)here.dimension(), pos);
        }
        if ((targetLevel = Objects.requireNonNull(player.getServer()).getLevel(be.linkedDimension())) == null) {
            return;
        }
        BlockPos linkPos = be.linkedPosition();
        double ty = (double)linkPos.getY() + 1.0;
        player.teleportTo(targetLevel, (double)linkPos.getX() + 0.5, ty, (double)linkPos.getZ() + 0.5, player.getYRot(), player.getXRot());
        evt.setCancellationResult(InteractionResult.SUCCESS);
        evt.setCanceled(true);
    }

    private static BlockPos findTopSolidBlock(ServerLevel lvl, int x, int z) {
        int y = lvl.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z)).getY();
        return new BlockPos(x, y, z);
    }
}

