/*
 * Decompiled with CFR 0.152.
 */
package com.envygames.dimensionalpha.blockentity;

import com.envygames.dimensionalpha.blockentity.ModBlockEntities;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleporterBlockEntity
extends BlockEntity {
    private static final String NBT_DIM = "Dim";
    private static final String NBT_POS = "Pos";
    @Nullable
    private ResourceKey<Level> linkedDim;
    @Nullable
    private BlockPos linkedPos;

    public TeleporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TELEPORTER.get(), pos, state);
    }

    public boolean isLinked() {
        return this.linkedDim != null && this.linkedPos != null;
    }

    public void linkTo(ResourceKey<Level> dim, BlockPos pos) {
        this.linkedDim = dim;
        this.linkedPos = pos.immutable();
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Nullable
    public ResourceKey<Level> linkedDimension() {
        return this.linkedDim;
    }

    @Nullable
    public BlockPos linkedPosition() {
        return this.linkedPos;
    }

    public void clearLink() {
        this.linkedDim = null;
        this.linkedPos = null;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookups) {
        super.saveAdditional(tag, lookups);
        if (this.isLinked()) {
            tag.putString(NBT_DIM, Objects.requireNonNull(this.linkedDim).location().toString());
            tag.putLong(NBT_POS, Objects.requireNonNull(this.linkedPos).asLong());
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookups) {
        super.loadAdditional(tag, lookups);
        if (tag.contains(NBT_DIM) && tag.contains(NBT_POS)) {
            ResourceLocation id = Objects.requireNonNull(ResourceLocation.tryParse((String)tag.getString(NBT_DIM)));
            this.linkedDim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
            this.linkedPos = BlockPos.of((long)tag.getLong(NBT_POS));
        } else {
            this.linkedDim = null;
            this.linkedPos = null;
        }
    }
}

