/*
 * Decompiled with CFR 0.152.
 */
package com.envygames.dimensionalpha.event;

import com.envygames.dimensionalpha.ModBlocks;
import com.envygames.dimensionalpha.block.DimensionAlphaTeleporterBlock;
import com.envygames.dimensionalpha.blockentity.TeleporterBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="dimensionalpha")
public class PortalEvents {
    private static final ResourceKey<Level> ALPHA_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"dimensionalpha:eg_dimension_alpha"));

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock evt) {
        ServerLevel dest;
        if (evt.getHand() != InteractionHand.MAIN_HAND || evt.getLevel().isClientSide()) {
            return;
        }
        BlockPos pos = evt.getPos();
        BlockState state = evt.getLevel().getBlockState(pos);
        if (!state.is((Block)ModBlocks.DIMENSION_ALPHA_TELEPORTER.get())) {
            return;
        }
        ServerLevel here = (ServerLevel)evt.getLevel();
        ServerPlayer player = (ServerPlayer)evt.getEntity();
        TeleporterBlockEntity be = (TeleporterBlockEntity)here.getBlockEntity(pos);
        if (be == null) {
            return;
        }
        ServerLevel serverLevel = dest = here.dimension() == ALPHA_KEY ? here.getServer().getLevel(Level.OVERWORLD) : here.getServer().getLevel(ALPHA_KEY);
        if (dest == null) {
            return;
        }
        if (!be.isLinked()) {
            BlockPos destPos;
            if (dest.dimension() == ALPHA_KEY) {
                destPos = new BlockPos(pos.getX(), 270, pos.getZ());
                PortalEvents.ensurePadAndHeadroom(dest, destPos);
            } else {
                destPos = PortalEvents.pickOverworldSurfacePad(dest, pos.getX(), pos.getZ());
                PortalEvents.ensurePadAndHeadroom(dest, destPos);
            }
            TeleporterBlockEntity destBE = (TeleporterBlockEntity)dest.getBlockEntity(destPos);
            if (destBE == null) {
                return;
            }
            be.linkTo((ResourceKey<Level>)dest.dimension(), destPos);
            destBE.linkTo((ResourceKey<Level>)here.dimension(), pos);
        }
        assert (be.linkedDimension() != null);
        ServerLevel target = Objects.requireNonNull(player.getServer()).getLevel(be.linkedDimension());
        if (target == null) {
            return;
        }
        BlockPos linkPos = be.linkedPosition();
        if (target.dimension() == ALPHA_KEY) {
            assert (linkPos != null);
            if (linkPos.getY() != 270) {
                linkPos = new BlockPos(linkPos.getX(), 270, linkPos.getZ());
            }
            PortalEvents.ensurePadAndHeadroom(target, linkPos);
        } else if (target.dimension() == Level.OVERWORLD) {
            PortalEvents.ensurePadAndHeadroom(target, linkPos);
        }
        assert (linkPos != null);
        player.teleportTo(target, (double)linkPos.getX() + 0.5, (double)linkPos.getY() + 1.0, (double)linkPos.getZ() + 0.5, player.getYRot(), player.getXRot());
        evt.setCancellationResult(InteractionResult.SUCCESS);
        evt.setCanceled(true);
    }

    private static BlockPos pickOverworldSurfacePad(ServerLevel level, int x, int z) {
        int[][] OFF;
        for (int[] d : OFF = new int[][]{{0, 0}, {1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {-1, 1}, {1, -1}, {-1, -1}, {2, 0}, {-2, 0}, {0, 2}, {0, -2}}) {
            BlockPos pad = PortalEvents.surfacePadAt(level, x + d[0], z + d[1]);
            if (!PortalEvents.isGoodSurface(level, pad)) continue;
            return pad;
        }
        return PortalEvents.surfacePadAt(level, x, z);
    }

    private static BlockPos surfacePadAt(ServerLevel level, int x, int z) {
        int yFree = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        int padY = Math.max(level.getMinBuildHeight(), Math.min(yFree - 1, level.getMaxBuildHeight() - 1));
        return new BlockPos(x, padY, z);
    }

    private static boolean isGoodSurface(ServerLevel level, BlockPos padPos) {
        BlockState below = level.getBlockState(padPos.below());
        boolean supportSolid = !below.getCollisionShape((BlockGetter)level, padPos.below()).isEmpty();
        boolean dry = below.getFluidState().isEmpty();
        boolean headroom = PortalEvents.isPassable(level, padPos.above()) && PortalEvents.isPassable(level, padPos.above(2));
        return supportSolid && dry && headroom;
    }

    private static boolean isPassable(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    private static void ensurePadAndHeadroom(ServerLevel level, BlockPos padPos) {
        level.getChunkAt(padPos);
        BlockPos support = padPos.below();
        BlockState below = level.getBlockState(support);
        if (!below.getFluidState().isEmpty() || below.getCollisionShape((BlockGetter)level, support).isEmpty()) {
            level.setBlockAndUpdate(support, Blocks.STONE.defaultBlockState());
        }
        if (!level.getBlockState(padPos).is((Block)ModBlocks.DIMENSION_ALPHA_TELEPORTER.get())) {
            level.setBlockAndUpdate(padPos, ((DimensionAlphaTeleporterBlock)((Object)ModBlocks.DIMENSION_ALPHA_TELEPORTER.get())).defaultBlockState());
        }
        BlockPos one = padPos.above();
        BlockPos two = one.above();
        if (!PortalEvents.isPassable(level, one)) {
            level.setBlockAndUpdate(one, Blocks.AIR.defaultBlockState());
        }
        if (!PortalEvents.isPassable(level, two)) {
            level.setBlockAndUpdate(two, Blocks.AIR.defaultBlockState());
        }
    }
}

