/*
 * Decompiled with CFR 0.152.
 */
package net.cookedseafood.wandofsparking.data;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class WandOfSparkingConfig {
    public static final float MANA_CONSUMPTION = 2.0f;
    public static final double MOVEMENT_SPEED = 1.2;
    public static final short DISSIPATION_FUSE = 20;
    public static final float CASTING_DAMAGE = 3.0f;
    public static final byte PIERCE_COUNT = 1;
    public static final boolean IS_PARTICLE_VISIBLE = true;
    public static float manaConsumption;
    public static double movementSpeed;
    public static short dissipationFuse;
    public static float castingDamage;
    public static byte pierceCount;
    public static boolean isParticleVisible;

    public static int reload() {
        String configString;
        try {
            configString = FileUtils.readFileToString((File)new File("./config/wand-of-sparking.json"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            WandOfSparkingConfig.reset();
            return 1;
        }
        JsonObject config = (JsonObject)new Gson().fromJson(configString, JsonObject.class);
        if (config == null) {
            WandOfSparkingConfig.reset();
            return 1;
        }
        return WandOfSparkingConfig.reload(config);
    }

    public static int reload(JsonObject config) {
        MutableInt counter = new MutableInt(0);
        if (config.has("manaConsumption")) {
            manaConsumption = config.get("manaConsumption").getAsFloat();
            counter.increment();
        } else {
            manaConsumption = 2.0f;
        }
        if (config.has("movementSpeed")) {
            movementSpeed = config.get("movementSpeed").getAsDouble();
            counter.increment();
        } else {
            movementSpeed = 1.2;
        }
        if (config.has("dissipationFuse")) {
            dissipationFuse = config.get("dissipationFuse").getAsShort();
            counter.increment();
        } else {
            dissipationFuse = (short)20;
        }
        if (config.has("castingDamage")) {
            castingDamage = config.get("castingDamage").getAsFloat();
            counter.increment();
        } else {
            castingDamage = 3.0f;
        }
        if (config.has("pierceCount")) {
            pierceCount = config.get("pierceCount").getAsByte();
            counter.increment();
        } else {
            pierceCount = 1;
        }
        if (config.has("isParticleVisible")) {
            isParticleVisible = config.get("isParticleVisible").getAsBoolean();
            counter.increment();
        } else {
            isParticleVisible = true;
        }
        return counter.intValue();
    }

    public static void reset() {
        manaConsumption = 2.0f;
        movementSpeed = 1.2;
        dissipationFuse = (short)20;
        castingDamage = 3.0f;
        pierceCount = 1;
        isParticleVisible = true;
    }
}

