/*
 * Decompiled with CFR 0.152.
 */
package net.cookedseafood.wandofsparking.entity.projectile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.cookedseafood.wandofsparking.data.WandOfSparkingConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class SparkingEntity {
    private static final List<SparkingEntity> SPARKING_ENTITIES = new ArrayList<SparkingEntity>();
    private static Iterator<SparkingEntity> iterator;
    private class_3218 world;
    private class_243 pos;
    private class_243 velocity;
    private short fuse;
    @Nullable
    private class_1309 owner;
    private boolean leftOwner;
    private byte hitCount;
    public final class_5819 random = class_5819.method_43047();

    public SparkingEntity(class_3218 world) {
        this.world = world;
        this.pos = class_243.field_1353;
        this.velocity = class_243.field_1353;
        SPARKING_ENTITIES.add(this);
    }

    public static void tickAll() {
        iterator = SPARKING_ENTITIES.iterator();
        while (iterator.hasNext()) {
            iterator.next().tick();
        }
    }

    public void tick() {
        this.velocity.method_1021(0.99);
        this.velocity.method_1031(0.0, -0.05, 0.0);
        this.pos = this.pos.method_1019(this.velocity);
        class_2338 blockPos = class_2338.method_49638((class_2374)this.pos);
        if (!this.world.method_8320(blockPos).method_26220((class_1922)this.world, blockPos).method_1110() || !this.world.method_8316(blockPos).method_15769()) {
            this.remove();
            return;
        }
        if (WandOfSparkingConfig.isParticleVisible) {
            this.spawnTrailParticle();
        }
        List targets = this.world.method_8335(null, new class_238(this.pos.field_1352 - 0.25, this.pos.field_1351 - 0.25, this.pos.field_1350 - 0.25, this.pos.field_1352 + 0.25, this.pos.field_1351 + 0.25, this.pos.field_1350 + 0.25));
        if (!this.leftOwner) {
            if (targets.contains(this.owner)) {
                return;
            }
            this.leftOwner = true;
        }
        for (class_1297 target : targets) {
            this.onHit(target);
            this.fuse = (short)(this.fuse / 2);
            this.hitCount = (byte)(this.hitCount + 1);
            if (this.hitCount <= 1) continue;
            this.remove();
            return;
        }
        this.fuse = (short)(this.fuse - 1);
        if (this.fuse < 0) {
            this.remove();
        }
    }

    public void onHit(class_1297 target) {
        target.method_64397(this.world, this.world.method_48963().method_48796(class_8111.field_42349, (class_1297)this.owner), this.owner.getCastingDamageAgainst(target, 3.0f));
        if (this.random.method_43056()) {
            target.method_56073(this.random.method_43048(6) == 0 ? this.random.method_39332(40, 80) : this.random.method_39332(20, 40));
        }
    }

    public void remove() {
        iterator.remove();
    }

    public void spawnTrailParticle() {
        byte count = (byte)this.random.method_39332(16, 32);
        for (byte i = 0; i < count; i = (byte)(i + 1)) {
            double delta = Math.abs(this.random.method_43058() - this.random.method_43058());
            class_243 deltaOffset = this.velocity.method_22882().method_1021(delta);
            class_243 direction = this.velocity.method_1029();
            class_243 cross = direction.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            class_243 crossOffset = cross.method_1021(delta * this.random.method_43058() * (double)(this.random.method_43056() ? 1 : -1) * 0.5);
            class_243 perpendicular = direction.method_1036(cross).method_1029();
            double waveHeight = Math.sin(Math.PI * 8 * delta) * 0.125;
            class_243 waveOffset = perpendicular.method_1021(waveHeight);
            double randomOffsetScale = 0.01;
            class_243 randomOffset = new class_243(this.random.method_43058() * (double)(this.random.method_43056() ? 1 : -1) * randomOffsetScale, this.random.method_43058() * (double)(this.random.method_43056() ? 1 : -1) * randomOffsetScale, this.random.method_43058() * (double)(this.random.method_43056() ? 1 : -1) * randomOffsetScale);
            class_243 offset = deltaOffset.method_1019(crossOffset).method_1019(waveOffset).method_1019(randomOffset);
            this.world.method_65096((class_2394)class_2398.field_27783, this.pos.field_1352 + offset.field_1352, this.pos.field_1351 + offset.field_1351, this.pos.field_1350 + offset.field_1350, 0, offset.field_1352, offset.field_1351, offset.field_1350, 32768.0);
        }
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public void setWorld(class_3218 world) {
        this.world = world;
    }

    public SparkingEntity withWorld(class_3218 world) {
        this.setWorld(world);
        return this;
    }

    public class_243 getPos() {
        return this.pos;
    }

    public void setPos(class_243 pos) {
        this.pos = pos;
    }

    public SparkingEntity withPos(class_243 pos) {
        this.setPos(pos);
        return this;
    }

    public class_243 getVelocity() {
        return this.velocity;
    }

    public void setVelocity(class_243 velocity) {
        this.velocity = velocity;
    }

    public SparkingEntity withVelocity(class_243 velocity) {
        this.setVelocity(velocity);
        return this;
    }

    public short getFuse() {
        return this.fuse;
    }

    public void setFuse(short fuse) {
        this.fuse = fuse;
    }

    public SparkingEntity withFuse(short fuse) {
        this.setFuse(fuse);
        return this;
    }

    public class_1309 getOwner() {
        return this.owner;
    }

    public void setOwner(class_1309 owner) {
        this.owner = owner;
    }

    public SparkingEntity withOwner(class_1309 owner) {
        this.setOwner(owner);
        return this;
    }

    public boolean hasLeftOwner() {
        return this.leftOwner;
    }

    public void setLeftOwner(boolean leftOwner) {
        this.leftOwner = leftOwner;
    }

    public SparkingEntity withLeftOwner(boolean leftOwner) {
        this.setLeftOwner(leftOwner);
        return this;
    }

    public byte getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(byte hitCount) {
        this.hitCount = hitCount;
    }

    public SparkingEntity withHitCount(byte hitCount) {
        this.setHitCount(hitCount);
        return this;
    }
}

