/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.crypticverse.serverhelper.config.filter.FilterConfig;
import net.crypticverse.serverhelper.config.filter.MutedPlayer;
import net.crypticverse.serverhelper.config.filter.PlayerUtils;
import net.crypticverse.serverhelper.config.filter.TempMutedPlayer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;

public class MutePlayerCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        if (!FilterConfig.muteCommand) {
            return;
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mute").requires(source -> source.method_9259(1))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"permanent").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(context -> {
            int players = class_2191.method_9330((CommandContext)context, (String)"target").size();
            for (GameProfile profile : class_2191.method_9330((CommandContext)context, (String)"target")) {
                if (FilterConfig.isMuted(profile.getId())) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.alreadyMuted")));
                    if (players != 1) continue;
                    return 0;
                }
                FilterConfig.addMutedPlayer(profile.getId(), "No reason provided");
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.permanentlyMuted")), true);
            }
            FilterConfig.saveConfig();
            return 1;
        })).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            int players = class_2191.method_9330((CommandContext)context, (String)"target").size();
            for (GameProfile profile : class_2191.method_9330((CommandContext)context, (String)"target")) {
                if (FilterConfig.isMuted(profile.getId())) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.alreadyMuted")));
                    if (players != 1) continue;
                    return 0;
                }
                FilterConfig.addMutedPlayer(profile.getId(), (String)context.getArgument("reason", String.class));
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.permanentlyMuted")), true);
            }
            FilterConfig.saveConfig();
            return 1;
        }))))).then(class_2170.method_9247((String)"temporary").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)0, (int)525960)).executes(context -> {
            int players = class_2191.method_9330((CommandContext)context, (String)"target").size();
            for (GameProfile profile : class_2191.method_9330((CommandContext)context, (String)"target")) {
                if (FilterConfig.isMuted(profile.getId())) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.alreadyMuted")));
                    if (players != 1) continue;
                    return 0;
                }
                FilterConfig.addTempMutedPlayer(profile.getId(), IntegerArgumentType.getInteger((CommandContext)context, (String)"minutes"), "No reason provided");
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.temporarilyMuted")), true);
            }
            FilterConfig.saveConfig();
            return 1;
        }))).then(class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)0, (int)525960)).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            int players = class_2191.method_9330((CommandContext)context, (String)"target").size();
            for (GameProfile profile : class_2191.method_9330((CommandContext)context, (String)"target")) {
                if (FilterConfig.isMuted(profile.getId())) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.alreadyMuted")));
                    if (players != 1) continue;
                    return 0;
                }
                FilterConfig.addTempMutedPlayer(profile.getId(), IntegerArgumentType.getInteger((CommandContext)context, (String)"minutes"), StringArgumentType.getString((CommandContext)context, (String)"reason"));
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.temporarilyMuted")), true);
            }
            FilterConfig.saveConfig();
            return 1;
        })))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"target", (ArgumentType)class_2191.method_9329()).executes(context -> {
            int players = class_2191.method_9330((CommandContext)context, (String)"target").size();
            for (GameProfile profile : class_2191.method_9330((CommandContext)context, (String)"target")) {
                if (!FilterConfig.isMuted(profile.getId())) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.notMuted")));
                    if (players != 1) continue;
                    return 0;
                }
                FilterConfig.removeMutedPlayer(profile.getId());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)profile.getName()).method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.control.mute.unmuted")), true);
            }
            FilterConfig.saveConfig();
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(context -> {
            ArrayList<MutedPlayer> mutedPlayers = FilterConfig.getMutedPlayers();
            ArrayList<TempMutedPlayer> tempMutedPlayers = FilterConfig.getTempMutedPlayers();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"text.control.mute.mutedPlayers"), false);
            mutedPlayers.forEach(player -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)(PlayerUtils.getPlayerName(player.uuid().toString()) + " - " + player.reason())), false));
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"text.control.mute.tempMutedPlayers"), false);
            tempMutedPlayers.forEach(player -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)(PlayerUtils.getPlayerName(player.uuid().toString()) + " - " + player.reason())), false));
            return 1;
        }))));
    }
}

