/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.crypticverse.serverhelper.config.ranks.RanksConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

public class RankCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rank").requires(source -> source.method_9259(1))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            if (RanksConfig.isRank(id)) {
                ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"That rank already exists!"));
                return 0;
            }
            RanksConfig.createRole(id, name);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Created rank: " + StringArgumentType.getString((CommandContext)context, (String)"name"))), false);
            RanksConfig.saveConfig();
            return 1;
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(RanksConfig.ranks.keySet().stream().filter(id -> id.startsWith(builder.getRemaining())).toList(), (SuggestionsBuilder)builder)).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            if (!RanksConfig.isRank(id)) {
                ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"That rank does not exist!"));
                return 0;
            }
            RanksConfig.removeRole(id);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Removed rank: " + StringArgumentType.getString((CommandContext)context, (String)"id"))), false);
            RanksConfig.saveConfig();
            return 1;
        })))).then(class_2170.method_9247((String)"assign").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> {
            UUID playerId = class_2186.method_9315((CommandContext)context, (String)"player").method_5667();
            if (RanksConfig.isPlayerInRole(playerId, StringArgumentType.getString((CommandContext)context, (String)"rank"))) {
                ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"That player is already in a rank!"));
                return 0;
            }
            RanksConfig.addPlayerToRole(StringArgumentType.getString((CommandContext)context, (String)"rank"), playerId);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Added player to rank: " + StringArgumentType.getString((CommandContext)context, (String)"rank"))), false);
            RanksConfig.saveConfig();
            return 1;
        }))))).then(class_2170.method_9247((String)"unassign").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> {
            UUID playerId = class_2186.method_9315((CommandContext)context, (String)"player").method_5667();
            if (!RanksConfig.isPlayerInRole(playerId, StringArgumentType.getString((CommandContext)context, (String)"rank"))) {
                ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"That player is not in a rank!"));
                return 0;
            }
            RanksConfig.removePlayerFromRole(StringArgumentType.getString((CommandContext)context, (String)"rank"), playerId);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Removed player from rank: " + StringArgumentType.getString((CommandContext)context, (String)"player"))), false);
            RanksConfig.saveConfig();
            return 1;
        }))))).then(class_2170.method_9247((String)"list").executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"All ranks (by ID):"));
            for (String role : RanksConfig.ranks.keySet()) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)role));
            }
            return 1;
        })));
    }
}

