/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.config.dimension;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.crypticverse.serverhelper.ServerHelper;
import net.crypticverse.serverhelper.config.dimension.DimensionConfigTemplate;

public class DimensionConfig {
    public static boolean netherDisabled = false;
    public static boolean theEndDisabled = false;

    public static boolean isNetherDisabled() {
        return netherDisabled;
    }

    public static boolean isTheEndDisabled() {
        return theEndDisabled;
    }

    public static void loadConfig() {
        File file = ServerHelper.dimensionConfig.toFile();
        if (!file.exists()) {
            DimensionConfig.saveConfig();
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            Gson gson = new GsonBuilder().create();
            Type configType = new TypeToken<DimensionConfigTemplate>(){}.getType();
            DimensionConfigTemplate config = (DimensionConfigTemplate)gson.fromJson((Reader)fileReader, configType);
            netherDisabled = config.netherDisabled;
            theEndDisabled = config.theEndDisabled;
        }
        catch (IOException e) {
            ServerHelper.LOGGER.error("Error reading {}", (Object)file, (Object)e);
        }
    }

    public static void saveConfig() {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("netherDisabled", Boolean.valueOf(netherDisabled));
            jsonObject.addProperty("theEndDisabled", Boolean.valueOf(theEndDisabled));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)jsonObject);
            Files.write(ServerHelper.dimensionConfig, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            ServerHelper.LOGGER.error("Error saving {}", (Object)ServerHelper.dimensionConfig, (Object)e);
        }
    }
}

