/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.config.filter;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.crypticverse.serverhelper.ServerHelper;
import net.crypticverse.serverhelper.config.filter.FilterConfigTemplate;
import net.crypticverse.serverhelper.config.filter.MutedPlayer;
import net.crypticverse.serverhelper.config.filter.MutedPlayerTypeAdapter;
import net.crypticverse.serverhelper.config.filter.Offense;
import net.crypticverse.serverhelper.config.filter.ReplacementChar;
import net.crypticverse.serverhelper.config.filter.TempMutedPlayer;

public class FilterConfig {
    private static final ArrayList<String> regexes = new ArrayList();
    private static final ArrayList<String> phrases = new ArrayList();
    private static final ArrayList<String> words = new ArrayList();
    private static final ArrayList<String> standAloneWords = new ArrayList();
    private static final ArrayList<ReplacementChar> replacementChars = new ArrayList();
    private static final ArrayList<MutedPlayer> mutedPlayers = new ArrayList();
    private static final ArrayList<TempMutedPlayer> tempMutedPlayers = new ArrayList();
    private static final ArrayList<UUID> ignoredPlayers = new ArrayList();
    public static boolean logFiltered = true;
    public static boolean ignorePrivateMessages = false;
    public static boolean caseSensitive = false;
    public static boolean muteCommand = true;
    public static boolean tellPlayer = true;
    public static boolean censorAndSend = false;
    public static boolean muteAfterOffense = false;
    public static MuteType muteAfterOffenseType = MuteType.TEMPORARY;
    public static int muteAfterOffenseMinutes = 5;
    public static int muteAfterOffenseNumber = 3;
    public static int offenseExpireMinutes = 30;
    public static ArrayList<Offense> offenses = new ArrayList();

    public static ArrayList<String> getRegexes() {
        return (ArrayList)regexes.clone();
    }

    public static ArrayList<String> getPhrases() {
        return (ArrayList)phrases.clone();
    }

    public static ArrayList<String> getWords() {
        return (ArrayList)words.clone();
    }

    public static ArrayList<String> getStandAloneWords() {
        return (ArrayList)standAloneWords.clone();
    }

    public static ArrayList<MutedPlayer> getMutedPlayers() {
        return (ArrayList)mutedPlayers.clone();
    }

    public static ArrayList<TempMutedPlayer> getTempMutedPlayers() {
        return (ArrayList)tempMutedPlayers.clone();
    }

    public static ArrayList<ReplacementChar> getReplacementChars() {
        return (ArrayList)replacementChars.clone();
    }

    public static ArrayList<UUID> getIgnoredPlayers() {
        return (ArrayList)ignoredPlayers.clone();
    }

    public static void addRegex(String regex) {
        regexes.add(regex);
    }

    public static void addPhrase(String phrase) {
        phrases.add(phrase);
    }

    public static void addWord(String word) {
        words.add(word);
    }

    public static void addStandAloneWord(String standAloneWord) {
        standAloneWords.add(standAloneWord);
    }

    public static void addMutedPlayer(UUID player, String reason) {
        mutedPlayers.add(new MutedPlayer(player, reason));
    }

    public static void addTempMutedPlayer(UUID player, long time, String reason) {
        tempMutedPlayers.add(new TempMutedPlayer(player, time, reason));
    }

    public static void addReplacementChar(char replacementChar, char replacement) {
        replacementChars.add(new ReplacementChar(replacementChar, replacement));
    }

    public static void addIgnoredPlayer(UUID player) {
        ignoredPlayers.add(player);
    }

    public static void addOffense(UUID player) {
        offenses.add(new Offense(player, Instant.now().getEpochSecond()));
    }

    public static void removeOffenses(UUID player) {
        offenses.removeIf(offense -> offense.uuid().equals(player));
    }

    public static void removeOldOffenses() {
        offenses.removeIf(offense -> Instant.now().getEpochSecond() - offense.time() > (long)offenseExpireMinutes * 60L);
    }

    public static int offenseCount(UUID player) {
        FilterConfig.removeOldOffenses();
        int count = 0;
        for (Offense offense : offenses) {
            if (!offense.uuid().equals(player)) continue;
            ++count;
        }
        return count;
    }

    public static void removeRegex(String regex) {
        regexes.remove(regex);
    }

    public static void removePhrase(String phrase) {
        phrases.remove(phrase);
    }

    public static void removeWord(String word) {
        words.remove(word);
    }

    public static void removeStandAloneWord(String standAloneWord) {
        standAloneWords.remove(standAloneWord);
    }

    public static void removeMutedPlayer(UUID player) {
        mutedPlayers.removeIf(mutedPlayer -> mutedPlayer.uuid().equals(player));
        for (TempMutedPlayer tempMutedPlayer : tempMutedPlayers) {
            if (!tempMutedPlayer.uuid().equals(player)) continue;
            FilterConfig.removeTempMutedPlayer(tempMutedPlayer);
            break;
        }
    }

    public static void removeTempMutedPlayer(TempMutedPlayer player) {
        tempMutedPlayers.remove(player);
    }

    public static void removeReplacementChar(char replacementChar, char replaceWith) {
        replacementChars.removeIf(replacementChar1 -> replacementChar1.toReplace == replacementChar && replacementChar1.replaceWith == replaceWith);
    }

    public static void removeIgnoredPlayer(UUID player) {
        ignoredPlayers.remove(player);
    }

    public static boolean isRegex(String word) {
        return regexes.contains(word);
    }

    public static boolean isPhrase(String phrase) {
        return phrases.contains(phrase);
    }

    public static boolean isWord(String word) {
        return words.contains(word);
    }

    public static boolean isStandAloneWord(String standAloneWord) {
        return standAloneWords.contains(standAloneWord);
    }

    public static boolean isMuted(UUID player) {
        return mutedPlayers.stream().anyMatch(mutedPlayer -> mutedPlayer.uuid().equals(player)) || FilterConfig.isTempMuted(player);
    }

    public static String getMuteReason(UUID player) {
        for (MutedPlayer mutedPlayer : mutedPlayers) {
            if (!mutedPlayer.uuid().equals(player)) continue;
            return mutedPlayer.reason();
        }
        for (TempMutedPlayer tempMutedPlayer : tempMutedPlayers) {
            if (!tempMutedPlayer.uuid().equals(player)) continue;
            return tempMutedPlayer.reason();
        }
        return "";
    }

    public static boolean isTempMuted(UUID player) {
        for (TempMutedPlayer tempMutedPlayer : tempMutedPlayers) {
            if (!tempMutedPlayer.uuid().equals(player)) continue;
            if (System.currentTimeMillis() >= tempMutedPlayer.until()) {
                FilterConfig.removeTempMutedPlayer(tempMutedPlayer);
                return false;
            }
            return true;
        }
        return false;
    }

    public static long timeLeftTempMuted(UUID player) {
        for (TempMutedPlayer tempMutedPlayer : tempMutedPlayers) {
            if (!tempMutedPlayer.uuid().equals(player)) continue;
            if (System.currentTimeMillis() >= tempMutedPlayer.until()) {
                FilterConfig.removeTempMutedPlayer(tempMutedPlayer);
                return 0L;
            }
            return tempMutedPlayer.until() - System.currentTimeMillis();
        }
        return 0L;
    }

    public static boolean isReplacementChar(ReplacementChar look) {
        for (ReplacementChar replacementChar : replacementChars) {
            if (replacementChar.toReplace != look.toReplace || replacementChar.replaceWith != look.replaceWith) continue;
            return true;
        }
        return false;
    }

    public static boolean isIgnored(UUID player) {
        return ignoredPlayers.contains(player);
    }

    public static boolean checkWords(String string) {
        for (String message : FilterConfig.replacedCharPossibilities(string)) {
            message = caseSensitive ? message : message.toLowerCase();
            for (String word : words) {
                String adjustedWord = caseSensitive ? word : word.toLowerCase();
                if (!message.contains(adjustedWord)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkStandAloneWords(String string) {
        for (String message : FilterConfig.replacedCharPossibilities(string)) {
            message = caseSensitive ? message : message.toLowerCase();
            for (String standAloneWord : standAloneWords) {
                String adjustedStandAloneWord = caseSensitive ? standAloneWord : standAloneWord.toLowerCase();
                String regex = "\\b" + Pattern.quote(adjustedStandAloneWord) + "\\b";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(message);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkPhrases(String string) {
        for (String message : FilterConfig.replacedCharPossibilities(string)) {
            message = caseSensitive ? message : message.toLowerCase();
            for (String phrase : phrases) {
                String adjustedPhrase = caseSensitive ? phrase : phrase.toLowerCase();
                if (!message.contains(adjustedPhrase)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkRegexes(String string) {
        for (String message : FilterConfig.replacedCharPossibilities(string)) {
            for (String regex : regexes) {
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(message);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    public static int countInString(String message, char c) {
        int count = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String censorWords(String string) {
        String mostFilteredMessage = "";
        for (String message : FilterConfig.replacedCharPossibilities((String)string)) {
            StringBuilder modifiedMessage = new StringBuilder(message);
            message = caseSensitive ? message : message.toLowerCase();
            for (String word : words) {
                String adjustedWord = caseSensitive ? word : word.toLowerCase();
                if (!message.contains(adjustedWord)) continue;
                String replacement = "#".repeat(word.length());
                modifiedMessage = new StringBuilder(modifiedMessage.toString().replace(word, replacement));
            }
            if (FilterConfig.countInString(modifiedMessage.toString(), '#') < FilterConfig.countInString(mostFilteredMessage, '#')) continue;
            mostFilteredMessage = modifiedMessage.toString();
        }
        for (int i = 0; i < mostFilteredMessage.length(); ++i) {
            if (mostFilteredMessage.charAt(i) != '#') continue;
            string = ((String)string).substring(0, i) + "#" + ((String)string).substring(i + 1);
        }
        return string;
    }

    public static String censorStandAloneWords(String string) {
        String mostFilteredMessage = "";
        for (String message : FilterConfig.replacedCharPossibilities((String)string)) {
            StringBuilder modifiedMessage = new StringBuilder(message);
            message = caseSensitive ? message : message.toLowerCase();
            for (String standAloneWord : standAloneWords) {
                String adjustedStandAloneWord = caseSensitive ? standAloneWord : standAloneWord.toLowerCase();
                String regex = "\\b" + Pattern.quote(adjustedStandAloneWord) + "\\b";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(message);
                while (matcher.find()) {
                    String replacement = "#".repeat(standAloneWord.length());
                    modifiedMessage.replace(matcher.start(), matcher.end(), replacement);
                    message = modifiedMessage.toString().toLowerCase();
                    matcher = pattern.matcher(message);
                }
            }
            if (FilterConfig.countInString(modifiedMessage.toString(), '#') < FilterConfig.countInString(mostFilteredMessage, '#')) continue;
            mostFilteredMessage = modifiedMessage.toString();
        }
        for (int i = 0; i < mostFilteredMessage.length(); ++i) {
            if (mostFilteredMessage.charAt(i) != '#') continue;
            string = ((String)string).substring(0, i) + "#" + ((String)string).substring(i + 1);
        }
        return string;
    }

    public static String censorPhrases(String string) {
        String mostFilteredMessage = "";
        for (String message : FilterConfig.replacedCharPossibilities((String)string)) {
            StringBuilder modifiedMessage = new StringBuilder(message);
            message = caseSensitive ? message : message.toLowerCase();
            for (String phrase : phrases) {
                String adjustedPhrase = caseSensitive ? phrase : phrase.toLowerCase();
                int index = message.indexOf(adjustedPhrase);
                while (index != -1) {
                    String replacement = "#".repeat(phrase.length());
                    modifiedMessage.replace(index, index + adjustedPhrase.length(), replacement);
                    message = modifiedMessage.toString().toLowerCase();
                    index = message.indexOf(adjustedPhrase, index + replacement.length());
                }
            }
            if (FilterConfig.countInString(modifiedMessage.toString(), '#') < FilterConfig.countInString(mostFilteredMessage, '#')) continue;
            mostFilteredMessage = modifiedMessage.toString();
        }
        for (int i = 0; i < mostFilteredMessage.length(); ++i) {
            if (mostFilteredMessage.charAt(i) != '#') continue;
            string = ((String)string).substring(0, i) + "#" + ((String)string).substring(i + 1);
        }
        return string;
    }

    public static String censorRegexes(String string) {
        String mostFilteredMessage = "";
        for (String message : FilterConfig.replacedCharPossibilities((String)string)) {
            StringBuilder modifiedMessage = new StringBuilder(message);
            for (String regex : regexes) {
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(message);
                while (matcher.find()) {
                    String replacement = "#".repeat(matcher.group().length());
                    modifiedMessage.replace(matcher.start(), matcher.end(), replacement);
                    matcher = pattern.matcher(modifiedMessage);
                }
            }
            if (FilterConfig.countInString(modifiedMessage.toString(), '#') < FilterConfig.countInString(mostFilteredMessage, '#')) continue;
            mostFilteredMessage = modifiedMessage.toString();
        }
        for (int i = 0; i < mostFilteredMessage.length(); ++i) {
            if (mostFilteredMessage.charAt(i) != '#') continue;
            string = ((String)string).substring(0, i) + "#" + ((String)string).substring(i + 1);
        }
        return string;
    }

    public static ArrayList<String> replacedCharPossibilities(String input) {
        ArrayList<String> results = new ArrayList<String>();
        FilterConfig.generateReplacementsHelper(input.toCharArray(), 0, results);
        return results;
    }

    private static void generateReplacementsHelper(char[] input, int index, ArrayList<String> results) {
        if (index == input.length) {
            results.add(new String(input));
            return;
        }
        FilterConfig.generateReplacementsHelper(input, index + 1, results);
        for (ReplacementChar rc : replacementChars) {
            if (input[index] != rc.toReplace) continue;
            char originalChar = input[index];
            input[index] = rc.replaceWith;
            FilterConfig.generateReplacementsHelper(input, index + 1, results);
            input[index] = originalChar;
        }
    }

    public static void loadConfig() {
        File file = ServerHelper.filterConfigFile.toFile();
        if (!file.exists()) {
            FilterConfig.saveConfig();
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            Gson gson = new GsonBuilder().registerTypeAdapter(MutedPlayer.class, (Object)new MutedPlayerTypeAdapter()).create();
            Type configType = new TypeToken<FilterConfigTemplate>(){}.getType();
            FilterConfigTemplate config = (FilterConfigTemplate)gson.fromJson((Reader)fileReader, configType);
            regexes.addAll(config.regexes);
            phrases.addAll(config.phrases);
            words.addAll(config.words);
            standAloneWords.addAll(config.standAloneWords);
            replacementChars.addAll(config.replacementChars);
            mutedPlayers.addAll(config.mutedPlayers);
            tempMutedPlayers.addAll(config.tempMutedPlayers);
            ignoredPlayers.addAll(config.ignoredPlayers);
            logFiltered = config.logFiltered;
            ignorePrivateMessages = config.ignorePrivateMessages;
            caseSensitive = config.caseSensitive;
            muteCommand = config.muteCommand;
            tellPlayer = config.tellPlayer;
            censorAndSend = config.censorAndSend;
            muteAfterOffense = config.muteAfterOffense;
            muteAfterOffenseType = config.muteAfterOffenseType;
            muteAfterOffenseMinutes = config.muteAfterOffenseMinutes;
            muteAfterOffenseNumber = config.muteAfterOffenseNumber;
            offenseExpireMinutes = config.offenseExpireMinutes;
            offenses.addAll(config.offenses);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("regexes", (JsonElement)FilterConfig.arrayListToJsonArray(regexes));
            jsonObject.add("phrases", (JsonElement)FilterConfig.arrayListToJsonArray(phrases));
            jsonObject.add("words", (JsonElement)FilterConfig.arrayListToJsonArray(words));
            jsonObject.add("standAloneWords", (JsonElement)FilterConfig.arrayListToJsonArray(standAloneWords));
            jsonObject.add("replacementChars", (JsonElement)FilterConfig.replacementsToJsonArray(replacementChars));
            jsonObject.add("mutedPlayers", (JsonElement)FilterConfig.mutedPlayersToJsonArray(mutedPlayers));
            jsonObject.add("tempMutedPlayers", (JsonElement)FilterConfig.tempMutedPlayersToJsonArray(tempMutedPlayers));
            jsonObject.add("ignoredPlayers", (JsonElement)FilterConfig.arrayListToJsonArray(ignoredPlayers));
            jsonObject.addProperty("logFiltered", Boolean.valueOf(logFiltered));
            jsonObject.addProperty("ignorePrivateMessages", Boolean.valueOf(ignorePrivateMessages));
            jsonObject.addProperty("caseSensitive", Boolean.valueOf(caseSensitive));
            jsonObject.addProperty("muteCommand", Boolean.valueOf(muteCommand));
            jsonObject.addProperty("tellPlayer", Boolean.valueOf(tellPlayer));
            jsonObject.addProperty("censorAndSend", Boolean.valueOf(censorAndSend));
            jsonObject.addProperty("muteAfterOffense", Boolean.valueOf(muteAfterOffense));
            jsonObject.addProperty("muteAfterOffenseType", muteAfterOffenseType.toString());
            jsonObject.addProperty("muteAfterOffenseMinutes", (Number)muteAfterOffenseMinutes);
            jsonObject.addProperty("muteAfterOffenseNumber", (Number)muteAfterOffenseNumber);
            jsonObject.addProperty("offenseExpireMinutes", (Number)offenseExpireMinutes);
            jsonObject.add("offenses", (JsonElement)FilterConfig.offensesToJsonArray(offenses));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)jsonObject);
            Files.write(ServerHelper.filterConfigFile, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JsonArray arrayListToJsonArray(ArrayList<?> list) {
        JsonArray jsonArray = new JsonArray();
        for (Object object : list) {
            jsonArray.add(object.toString());
        }
        return jsonArray;
    }

    public static JsonArray replacementsToJsonArray(ArrayList<ReplacementChar> list) {
        JsonArray jsonArray = new JsonArray();
        for (ReplacementChar replacementChar : list) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("toReplace", Character.valueOf(replacementChar.toReplace));
            jsonObject.addProperty("replaceWith", Character.valueOf(replacementChar.replaceWith));
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static JsonArray tempMutedPlayersToJsonArray(ArrayList<TempMutedPlayer> list) {
        JsonArray jsonArray = new JsonArray();
        for (TempMutedPlayer tempMutedPlayer : list) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("uuid", tempMutedPlayer.uuid().toString());
            jsonObject.addProperty("until", (Number)tempMutedPlayer.until());
            jsonObject.addProperty("reason", tempMutedPlayer.reason());
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static JsonArray mutedPlayersToJsonArray(ArrayList<MutedPlayer> list) {
        JsonArray jsonArray = new JsonArray();
        for (MutedPlayer tempMutedPlayer : list) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("uuid", tempMutedPlayer.uuid().toString());
            jsonObject.addProperty("reason", tempMutedPlayer.reason());
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static JsonArray offensesToJsonArray(ArrayList<Offense> list) {
        JsonArray jsonArray = new JsonArray();
        for (Offense offense : list) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("uuid", offense.uuid().toString());
            jsonObject.addProperty("time", (Number)offense.time());
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static enum MuteType {
        PERMANENT,
        TEMPORARY;

    }
}

