/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.config.filter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;
import net.crypticverse.serverhelper.config.filter.MutedPlayer;

public class MutedPlayerTypeAdapter
extends TypeAdapter<MutedPlayer> {
    public void write(JsonWriter out, MutedPlayer value) throws IOException {
        out.beginObject();
        out.name("uuid").value(value.uuid().toString());
        out.name("reason").value(value.reason());
        out.endObject();
    }

    public MutedPlayer read(JsonReader in) throws IOException {
        UUID uuid = null;
        String reason = null;
        if (in.peek() == JsonToken.STRING) {
            uuid = UUID.fromString(in.nextString());
            reason = "No reason provided";
        } else if (in.peek() == JsonToken.BEGIN_OBJECT) {
            in.beginObject();
            block8: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "uuid": {
                        uuid = UUID.fromString(in.nextString());
                        continue block8;
                    }
                    case "reason": {
                        reason = in.nextString();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
        }
        if (uuid == null) {
            throw new IOException("Missing uuid");
        }
        return new MutedPlayer(uuid, reason);
    }
}

