/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.config.filter;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.crypticverse.serverhelper.ServerHelper;

public class PlayerUtils {
    public static String getPlayerName(String uuid) {
        try {
            String urlString = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
            URL url = new URI(urlString).toURL();
            JsonObject object = PlayerUtils.getJsonObject(url);
            return object.get("name").getAsString();
        }
        catch (Exception e) {
            ServerHelper.LOGGER.info("Failed to get player name for UUID: {}. Maybe you are offline?", (Object)uuid);
            return uuid;
        }
    }

    private static JsonObject getJsonObject(URL url) throws IOException {
        String line;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        return JsonParser.parseString((String)response.toString()).getAsJsonObject();
    }

    public static List<String> getPlayerNames(List<UUID> uuids) {
        ArrayList<String> names = new ArrayList<String>();
        for (UUID uuid : uuids) {
            names.add(PlayerUtils.getPlayerName(uuid.toString()));
        }
        return names;
    }
}

