/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.mixin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.Objects;
import java.util.regex.Pattern;
import net.crypticverse.serverhelper.ServerHelper;
import net.crypticverse.serverhelper.command.DimensionCommand;
import net.crypticverse.serverhelper.command.FilterMessageCommand;
import net.crypticverse.serverhelper.command.MutePlayerCommand;
import net.crypticverse.serverhelper.command.RankCommand;
import net.crypticverse.serverhelper.config.filter.FilterConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2170.class})
public class CommandsMixin {
    @Shadow
    @Final
    private CommandDispatcher<class_2168> field_9832;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;setConsumer(Lcom/mojang/brigadier/ResultConsumer;)V")})
    private void injectCommands(class_2170.class_5364 selection, class_7157 context, CallbackInfo info) {
        FilterMessageCommand.register(this.field_9832);
        MutePlayerCommand.register(this.field_9832);
        RankCommand.register(this.field_9832);
        DimensionCommand.register(this.field_9832);
    }

    @Inject(method={"performCommand"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPerformCommand(ParseResults<class_2168> parseResults, String command, CallbackInfo info) {
        class_2168 source = (class_2168)parseResults.getContext().getSource();
        if ((command = command.replaceFirst(Pattern.quote("/"), "")).startsWith("say") || command.startsWith("me") || !FilterConfig.ignorePrivateMessages && (command.startsWith("whisper") || command.startsWith("tell") || command.startsWith("msg") || command.startsWith("w"))) {
            String string = command.replaceFirst("say ", "");
            string = string.replaceFirst("me ", "");
            string = string.replaceFirst("w ", "");
            string = string.replaceFirst("tell ", "");
            string = string.replaceFirst("msg ", "");
            string = string.replaceFirst("w ", "");
            class_3222 sender = source.method_44023();
            if (sender == null || FilterConfig.isIgnored(sender.method_5667())) {
                return;
            }
            if (FilterConfig.isMuted(sender.method_5667()) || !FilterConfig.censorAndSend && (FilterConfig.checkWords(string) || FilterConfig.checkPhrases(string) || FilterConfig.checkRegexes(string) || FilterConfig.checkStandAloneWords(string))) {
                info.cancel();
                if (FilterConfig.logFiltered) {
                    ServerHelper.LOGGER.info(class_2561.method_30163((String)("Filtered message from: " + String.valueOf(sender.method_5476()) + " (" + String.valueOf(sender.method_5667()) + "):" + string)).getString());
                }
                if (FilterConfig.tellPlayer && FilterConfig.isTempMuted(sender.method_5667())) {
                    sender.method_64398(class_2561.method_30163((String)("You are muted for " + FilterConfig.timeLeftTempMuted(sender.method_5667()) / 60000L + ". Reason: " + FilterConfig.getMuteReason(sender.method_5667()))));
                } else if (FilterConfig.tellPlayer && FilterConfig.isMuted(sender.method_5667())) {
                    sender.method_64398(class_2561.method_30163((String)("You are muted. Reason: " + FilterConfig.getMuteReason(sender.method_5667()))));
                } else if (FilterConfig.tellPlayer) {
                    sender.method_64398(class_2561.method_30163((String)"Your message was filtered by the server. Please refrain from using that language."));
                    if (FilterConfig.muteAfterOffense) {
                        FilterConfig.addOffense(sender.method_5667());
                        if (FilterConfig.offenseCount(sender.method_5667()) >= FilterConfig.muteAfterOffenseNumber) {
                            if (FilterConfig.muteAfterOffenseType == FilterConfig.MuteType.PERMANENT) {
                                FilterConfig.addMutedPlayer(sender.method_5667(), class_2561.method_30163((String)"Repeated offenses").getString());
                                sender.method_64398(class_2561.method_30163((String)"You have been permanently muted for repeated offenses"));
                            } else {
                                FilterConfig.addTempMutedPlayer(sender.method_5667(), System.currentTimeMillis() + (long)FilterConfig.muteAfterOffenseMinutes * 60000L, class_2561.method_30163((String)"Repeated offenses").getString());
                                sender.method_64398(class_2561.method_30163((String)("You have been temporarily muted for " + FilterConfig.muteAfterOffenseMinutes + " minutes due to repeated offenses")));
                            }
                            FilterConfig.removeOffenses(sender.method_5667());
                        }
                    }
                }
            }
        }
    }

    @ModifyVariable(method={"performCommand"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private ParseResults<class_2168> onPerformCommands(ParseResults<class_2168> parseResults, ParseResults<class_2168> p, String command) {
        class_2168 source = (class_2168)parseResults.getContext().getSource();
        if ((command = command.replaceFirst(Pattern.quote("/"), "")).startsWith("say") || command.startsWith("me") || !FilterConfig.ignorePrivateMessages && (command.startsWith("whisper") || command.startsWith("tell") || command.startsWith("msg") || command.startsWith("w"))) {
            String string = command.replaceFirst("say ", "");
            string = string.replaceFirst("me ", "");
            string = string.replaceFirst("w ", "");
            string = string.replaceFirst("tell ", "");
            string = string.replaceFirst("msg ", "");
            string = string.replaceFirst("w ", "");
            class_3222 sender = source.method_44023();
            if (sender == null || FilterConfig.isIgnored(sender.method_5667())) {
                return parseResults;
            }
            if (!FilterConfig.isMuted(sender.method_5667()) && FilterConfig.censorAndSend) {
                String newMessage = FilterConfig.censorWords(string);
                newMessage = FilterConfig.censorPhrases(newMessage);
                newMessage = FilterConfig.censorRegexes(newMessage);
                newMessage = FilterConfig.censorStandAloneWords(newMessage);
                if (!(newMessage = FilterConfig.censorWords(newMessage)).equals(string)) {
                    if (FilterConfig.muteAfterOffense) {
                        FilterConfig.addOffense(sender.method_5667());
                        if (FilterConfig.offenseCount(sender.method_5667()) >= FilterConfig.muteAfterOffenseNumber) {
                            if (FilterConfig.muteAfterOffenseType == FilterConfig.MuteType.PERMANENT) {
                                FilterConfig.addMutedPlayer(sender.method_5667(), class_2561.method_30163((String)"Repeated offenses").getString());
                                sender.method_64398(class_2561.method_30163((String)"You have been permanently muted for repeated offenses"));
                            } else {
                                FilterConfig.addTempMutedPlayer(sender.method_5667(), System.currentTimeMillis() + (long)FilterConfig.muteAfterOffenseMinutes * 60000L, class_2561.method_30163((String)"Repeated offenses").getString());
                                sender.method_64398(class_2561.method_30163((String)("You have been temporarily muted for " + FilterConfig.muteAfterOffenseMinutes + " minutes due to repeated offenses")));
                            }
                            FilterConfig.removeOffenses(sender.method_5667());
                        }
                    }
                    return this.field_9832.parse(command.split(" ")[0] + " " + newMessage, (Object)source);
                }
            }
        }
        return parseResults;
    }

    @ModifyVariable(method={"performCommand"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private String onPerformCommand(String command, ParseResults<class_2168> parseResults, String c) {
        class_2168 source = (class_2168)parseResults.getContext().getSource();
        String newCommand = command.replaceFirst(Pattern.quote("/"), "");
        if (newCommand.startsWith("say") || newCommand.startsWith("me") || !FilterConfig.ignorePrivateMessages && (newCommand.startsWith("whisper") || newCommand.startsWith("tell") || newCommand.startsWith("msg") || newCommand.startsWith("w"))) {
            String string = newCommand.replaceFirst("say ", "");
            string = string.replaceFirst("me ", "");
            string = string.replaceFirst("w ", "");
            string = string.replaceFirst("tell ", "");
            string = string.replaceFirst("msg ", "");
            string = string.replaceFirst("w ", "");
            class_3222 sender = source.method_44023();
            if (sender == null || FilterConfig.isIgnored(sender.method_5667())) {
                return command;
            }
            if (!FilterConfig.isMuted(sender.method_5667()) && FilterConfig.censorAndSend) {
                String newMessage = FilterConfig.censorWords(string);
                newMessage = FilterConfig.censorPhrases(newMessage);
                newMessage = FilterConfig.censorRegexes(newMessage);
                newMessage = FilterConfig.censorStandAloneWords(newMessage);
                if (!(newMessage = FilterConfig.censorWords(newMessage)).equals(string)) {
                    if (FilterConfig.tellPlayer) {
                        sender.method_64398(class_2561.method_30163((String)"Your message was censored by the server"));
                    }
                    if (FilterConfig.logFiltered) {
                        ServerHelper.LOGGER.info(class_2561.method_30163((String)"Censored message from ").getString() + Objects.requireNonNull(sender.method_5476()).getString() + " (" + String.valueOf(sender.method_5667()) + "): " + string);
                    }
                    if (FilterConfig.muteAfterOffense) {
                        FilterConfig.addOffense(sender.method_5667());
                        if (FilterConfig.offenseCount(sender.method_5667()) >= FilterConfig.muteAfterOffenseNumber) {
                            if (FilterConfig.muteAfterOffenseType == FilterConfig.MuteType.PERMANENT) {
                                FilterConfig.addMutedPlayer(sender.method_5667(), class_2561.method_30163((String)"Repeated offenses").getString());
                                sender.method_64398(class_2561.method_30163((String)"You have been permanently muted for repeated offenses"));
                            } else {
                                FilterConfig.addTempMutedPlayer(sender.method_5667(), System.currentTimeMillis() + (long)FilterConfig.muteAfterOffenseMinutes * 60000L, class_2561.method_30163((String)"Repeated offenses").getString());
                                sender.method_64398(class_2561.method_30163((String)("You have been temporarily muted for " + FilterConfig.muteAfterOffenseMinutes + " minutes due to repeated offenses")));
                            }
                            FilterConfig.removeOffenses(sender.method_5667());
                        }
                    }
                    return command.split(" ")[0] + " " + newMessage;
                }
            }
        }
        return command;
    }
}

