/*
 * Decompiled with CFR 0.152.
 */
package net.crypticverse.serverhelper.mixin;

import java.util.Objects;
import net.crypticverse.serverhelper.ServerHelper;
import net.crypticverse.serverhelper.config.filter.FilterConfig;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7471;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class}, priority=500)
public class ServerNetworkHandlerMixin {
    @Inject(method={"broadcastChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleDecoratedMessage(class_7471 message, CallbackInfo ci) {
        class_3222 sender = ((class_3244)this).field_14140;
        if (sender == null || FilterConfig.isIgnored(sender.method_5667())) {
            return;
        }
        String string = message.method_46291().getString();
        if (FilterConfig.isMuted(sender.method_5667()) || !FilterConfig.censorAndSend && (FilterConfig.checkWords(string) || FilterConfig.checkPhrases(string) || FilterConfig.checkRegexes(string) || FilterConfig.checkStandAloneWords(string))) {
            ci.cancel();
            if (FilterConfig.logFiltered) {
                ServerHelper.LOGGER.info(class_2561.method_30163((String)("Filtered message from: " + String.valueOf(sender.method_5476()) + " (" + String.valueOf(sender.method_5667()) + "): " + String.valueOf(message))).getString());
            }
            if (FilterConfig.tellPlayer && FilterConfig.isTempMuted(sender.method_5667())) {
                sender.method_64398(class_2561.method_30163((String)("You are muted for " + FilterConfig.timeLeftTempMuted(sender.method_5667()) / 60000L + " more minutes. Reason: " + FilterConfig.getMuteReason(sender.method_5667()))));
            } else if (FilterConfig.tellPlayer && FilterConfig.isMuted(sender.method_5667())) {
                sender.method_64398(class_2561.method_30163((String)("You are muted. Reason: " + FilterConfig.getMuteReason(sender.method_5667()))));
            } else if (FilterConfig.tellPlayer) {
                sender.method_64398(class_2561.method_30163((String)"Your message was filtered by the server. Please do not use that language!"));
                if (FilterConfig.muteAfterOffense) {
                    FilterConfig.addOffense(sender.method_5667());
                    if (FilterConfig.offenseCount(sender.method_5667()) >= FilterConfig.muteAfterOffenseNumber) {
                        if (FilterConfig.muteAfterOffenseType == FilterConfig.MuteType.PERMANENT) {
                            FilterConfig.addMutedPlayer(sender.method_5667(), class_2561.method_30163((String)"Repeated offenses").getString());
                            sender.method_64398(class_2561.method_30163((String)"You have been permanently muted for repeated offenses"));
                        } else {
                            FilterConfig.addTempMutedPlayer(sender.method_5667(), System.currentTimeMillis() + (long)FilterConfig.muteAfterOffenseMinutes * 60000L, class_2561.method_30163((String)"Repeated offenses.").getString());
                            sender.method_64398(class_2561.method_30163((String)("You have been temporarily muted for" + FilterConfig.muteAfterOffenseMinutes + " minutes due to repeated offenses")));
                        }
                        FilterConfig.removeOffenses(sender.method_5667());
                    }
                }
            }
        }
    }

    @ModifyVariable(method={"broadcastChatMessage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private class_7471 onHandleDecoratedMessage(class_7471 message, class_7471 m) {
        class_3222 sender = ((class_3244)this).field_14140;
        if (FilterConfig.ignorePrivateMessages || FilterConfig.isIgnored(sender.method_5667())) {
            return message;
        }
        if (!FilterConfig.isMuted(sender.method_5667()) && FilterConfig.censorAndSend) {
            String newMessage = FilterConfig.censorWords(message.method_46291().getString());
            newMessage = FilterConfig.censorPhrases(newMessage);
            newMessage = FilterConfig.censorRegexes(newMessage);
            newMessage = FilterConfig.censorStandAloneWords(newMessage);
            if (!(newMessage = FilterConfig.censorWords(newMessage)).equals(message.method_46291().getString())) {
                if (FilterConfig.tellPlayer) {
                    sender.method_64398(class_2561.method_30163((String)"Your message was censored by the server"));
                }
                if (FilterConfig.logFiltered) {
                    ServerHelper.LOGGER.info(class_2561.method_30163((String)"Censored message from ").getString() + Objects.requireNonNull(sender.method_5476()).getString() + " (" + String.valueOf(sender.method_5667()) + "): " + message.method_46291().getString());
                }
                if (FilterConfig.muteAfterOffense) {
                    FilterConfig.addOffense(sender.method_5667());
                    if (FilterConfig.offenseCount(sender.method_5667()) >= FilterConfig.muteAfterOffenseNumber) {
                        if (FilterConfig.muteAfterOffenseType == FilterConfig.MuteType.PERMANENT) {
                            FilterConfig.addMutedPlayer(sender.method_5667(), class_2561.method_30163((String)"Repeated offenses").getString());
                            sender.method_64398(class_2561.method_30163((String)"You have been permanently muted for repeated offenses"));
                        } else {
                            FilterConfig.addTempMutedPlayer(sender.method_5667(), System.currentTimeMillis() + (long)FilterConfig.muteAfterOffenseMinutes * 60000L, class_2561.method_30163((String)"Repeated offenses").getString());
                            sender.method_64398(class_2561.method_30163((String)("You have been temporarily muted for" + FilterConfig.muteAfterOffenseMinutes + " minutes due to repeated offenses")));
                        }
                        FilterConfig.removeOffenses(sender.method_5667());
                    }
                }
                return class_7471.method_45041((String)newMessage);
            }
        }
        return message;
    }
}

