/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.core;

import cn.anecansaitin.freecameraapi.api.ICameraModifier;
import cn.anecansaitin.freecameraapi.core.ModifierRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="free_camera_api")
public class CameraConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.ConfigValue<List<? extends String>> PLAYER_ORDER = BUILDER.comment(new String[]{"  The order of the camera modifiers.", "  If some plugins are not displayed, you can click \"Reset\" to refresh."}).defineListAllowEmpty("order", CameraConfig.defaultOrderList(), () -> "example:id", CameraConfig::validate);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> REMOVED = BUILDER.comment("  The modifiers that are removed.").defineListAllowEmpty("removed", new ArrayList(), () -> "example:id", CameraConfig::validate);
    public static final ModConfigSpec SPEC = BUILDER.build();

    private static boolean validate(Object obj) {
        return obj instanceof String;
    }

    public static void setPlayerOrder(List<String> list) {
        PLAYER_ORDER.set(list);
    }

    public static void setRemoved(List<String> list) {
        REMOVED.set(list);
    }

    public static void save() {
        SPEC.save();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        CameraConfig.checkConfig();
        ModifierRegistry.INSTANCE.freeze((List)PLAYER_ORDER.get(), (List)REMOVED.get());
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        CameraConfig.checkConfig();
        ModifierRegistry.INSTANCE.resetOrder((List)PLAYER_ORDER.get(), (List)REMOVED.get());
    }

    private static void checkConfig() {
        CameraConfig.checkId((List)PLAYER_ORDER.get());
        CameraConfig.checkId((List)REMOVED.get());
    }

    private static void checkId(List<? extends String> ids) {
        for (int i = ids.size() - 1; i >= 0; --i) {
            String s = ids.get(i);
            if (s.isBlank()) {
                ids.remove(i);
                continue;
            }
            String[] split = s.split(":");
            if (split.length != 2) {
                ids.remove(i);
                continue;
            }
            if (ResourceLocation.isValidNamespace((String)split[0]) && ResourceLocation.isValidPath((String)split[1])) continue;
            ids.remove(i);
        }
    }

    private static List<String> defaultOrderList() {
        List<ICameraModifier> list = ModifierRegistry.INSTANCE.getAllMoModifiers();
        ArrayList<String> defaultList = new ArrayList<String>();
        for (ICameraModifier modifier : list) {
            defaultList.add(modifier.getId().toString());
        }
        return defaultList;
    }
}

