/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.core;

import cn.anecansaitin.freecameraapi.api.ICameraModifier;
import cn.anecansaitin.freecameraapi.api.ICameraPlugin;
import cn.anecansaitin.freecameraapi.api.ModifierPriority;
import cn.anecansaitin.freecameraapi.core.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ModifierRegistry {
    public static final ModifierRegistry INSTANCE = new ModifierRegistry();
    private final Map<ModifierPriority, List<ICameraModifier>> priorityMap = new EnumMap<ModifierPriority, List<ICameraModifier>>(ModifierPriority.class);
    private final Map<ResourceLocation, ICameraModifier> modifierMap = new HashMap<ResourceLocation, ICameraModifier>();
    private final List<ICameraModifier> modifierList = new ArrayList<ICameraModifier>();
    private final List<ICameraModifier> removedList = new ArrayList<ICameraModifier>();
    private final Map<ICameraModifier, ICameraPlugin> plugins = new HashMap<ICameraModifier, ICameraPlugin>();
    private boolean frozen = false;

    private ModifierRegistry() {
        for (ModifierPriority priority : ModifierPriority.values()) {
            this.priorityMap.put(priority, new ArrayList());
        }
    }

    public void register(ResourceLocation id, ICameraPlugin plugin) {
        this.register(id, plugin, ModifierPriority.NORMAL);
    }

    public void register(ResourceLocation id, ICameraPlugin plugin, ModifierPriority priority) {
        this.register(plugin, priority, new Modifier(id));
    }

    public void register(ICameraPlugin plugin, ModifierPriority priority, ICameraModifier modifier) {
        if (this.frozen) {
            throw new IllegalStateException("ModifierRegistry is frozen");
        }
        if (this.modifierMap.containsKey(modifier.getId())) {
            throw new IllegalArgumentException("Modifier with id " + String.valueOf(modifier.getId()) + " already registered");
        }
        this.modifierMap.put(modifier.getId(), modifier);
        this.priorityMap.get((Object)priority).add(modifier);
        this.plugins.put(modifier, plugin);
        plugin.initialize(modifier);
    }

    public void freeze(List<String> order, List<String> removed) {
        if (this.frozen) {
            return;
        }
        this.frozen = true;
        this.sort();
        this.setOrderById(order, removed);
    }

    public void resetOrder(List<String> order, List<String> removed) {
        this.sort();
        this.setOrderById(order, removed);
    }

    private void sort() {
        for (ModifierPriority priority : ModifierPriority.values()) {
            this.modifierList.addAll((Collection<ICameraModifier>)this.priorityMap.get((Object)priority));
        }
    }

    private void setOrderById(List<String> order, List<String> removed) {
        ICameraModifier modifier;
        ArrayList<ICameraModifier> orderList = new ArrayList<ICameraModifier>();
        ArrayList<ICameraModifier> removedList = new ArrayList<ICameraModifier>();
        for (String id : order) {
            modifier = this.modifierMap.get(ResourceLocation.parse((String)id));
            if (modifier == null) continue;
            orderList.add(modifier);
        }
        for (String id : removed) {
            modifier = this.modifierMap.get(ResourceLocation.parse((String)id));
            if (modifier == null) continue;
            removedList.add(modifier);
        }
        this.modifierList.removeAll(orderList);
        this.modifierList.addAll(0, orderList);
        this.modifierList.removeAll(removedList);
        this.removedList.clear();
        this.removedList.addAll(removedList);
    }

    public void move(int index, int newIndex) {
        this.modifierList.add(newIndex, this.modifierList.remove(index));
    }

    public void remove(int index) {
        this.removedList.add(this.modifierList.remove(index));
    }

    public void moveBack(int index, int newIndex) {
        this.modifierList.add(newIndex, this.modifierList.remove(index));
    }

    public List<ICameraModifier> getAllMoModifiers() {
        ArrayList<ICameraModifier> modifiers = new ArrayList<ICameraModifier>();
        for (List<ICameraModifier> value : this.priorityMap.values()) {
            modifiers.addAll(value);
        }
        return modifiers;
    }

    public void updateController() {
        for (ICameraModifier modifier : this.modifierList) {
            this.plugins.get(modifier).update();
        }
    }

    @Nullable
    public ICameraModifier getActiveModifier() {
        for (ICameraModifier modifier : this.modifierList) {
            if (!modifier.isActive()) continue;
            return modifier;
        }
        return null;
    }
}

