/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.starup;

import cn.anecansaitin.freecameraapi.api.CameraPlugin;
import cn.anecansaitin.freecameraapi.api.ICameraPlugin;
import cn.anecansaitin.freecameraapi.api.ModifierPriority;
import cn.anecansaitin.freecameraapi.core.ModifierRegistry;
import cn.anecansaitin.freecameraapi.starup.CameraPluginInitializeException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import oshi.util.tuples.Triplet;

public final class PluginFinder {
    public static void loadPlugin() {
        for (Triplet<ResourceLocation, ICameraPlugin, ModifierPriority> triplet : PluginFinder.find()) {
            ModifierRegistry.INSTANCE.register((ResourceLocation)triplet.getA(), (ICameraPlugin)triplet.getB(), (ModifierPriority)((Object)triplet.getC()));
        }
    }

    private static List<Triplet<ResourceLocation, ICameraPlugin, ModifierPriority>> find() {
        Type type = Type.getType(CameraPlugin.class);
        ArrayList<Triplet<ResourceLocation, ICameraPlugin, ModifierPriority>> plugins = new ArrayList<Triplet<ResourceLocation, ICameraPlugin, ModifierPriority>>();
        List allScanData = ModList.get().getAllScanData();
        boolean dev = !FMLEnvironment.production;
        int allScanDataSize = allScanData.size();
        for (int i = 0; i < allScanDataSize; ++i) {
            ModFileScanData data = (ModFileScanData)allScanData.get(i);
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                if (!annotation.annotationType().equals((Object)type)) continue;
                String name = null;
                try {
                    String value = annotation.annotationData().get("value").toString();
                    if (!dev && value.equals("dev")) continue;
                    String namespace = ((IModInfo)ModList.get().getMods().get(i)).getNamespace();
                    ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)value);
                    ModAnnotation.EnumHolder priorityHolder = (ModAnnotation.EnumHolder)annotation.annotationData().get("priority");
                    ModifierPriority priority = ModifierPriority.NORMAL;
                    if (priorityHolder != null) {
                        priority = ModifierPriority.valueOf(priorityHolder.value());
                    }
                    name = annotation.memberName();
                    ICameraPlugin plugin = Class.forName(name).asSubclass(ICameraPlugin.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    plugins.add((Triplet<ResourceLocation, ICameraPlugin, ModifierPriority>)new Triplet((Object)id, (Object)plugin, (Object)priority));
                }
                catch (ClassNotFoundException e) {
                    throw CameraPluginInitializeException.classNotFound(name);
                }
                catch (NoSuchMethodException e) {
                    throw CameraPluginInitializeException.noSuchMethod(name);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw CameraPluginInitializeException.invocationTarget(name);
                }
            }
        }
        return plugins;
    }
}

