/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.zoom;

import cn.anecansaitin.freecameraapi.ClientUtil;
import cn.anecansaitin.freecameraapi.api.CameraPlugin;
import cn.anecansaitin.freecameraapi.api.ICameraModifier;
import cn.anecansaitin.freecameraapi.api.ICameraPlugin;
import cn.anecansaitin.freecameraapi.zoom.ModKeyMapping;
import cn.anecansaitin.freecameraapi.zoom.ZoomConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.ClientInput;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@EventBusSubscriber(modid="free_camera_api", value={Dist.CLIENT})
@CameraPlugin(value="zoom")
public class ZoomPlugin
implements ICameraPlugin {
    public static ZoomPlugin instance;
    private boolean enabled = false;
    private final Vector3f forward = new Vector3f();
    private final Vector3f pos = new Vector3f();
    private final Vector3f posO = new Vector3f();
    private ICameraModifier modifier;

    @Override
    public void initialize(ICameraModifier modifier) {
        instance = this;
        this.modifier = modifier;
        modifier.disable().enablePos().enableFov().enableGlobalMode();
    }

    @Override
    public void update() {
        float f = ClientUtil.partialTicks();
        this.modifier.setPos(Mth.lerp((float)f, (float)this.posO.x, (float)this.pos.x), Mth.lerp((float)f, (float)this.posO.y, (float)this.pos.y), Mth.lerp((float)f, (float)this.posO.z, (float)this.pos.z));
        this.modifier.setFov(ZoomConfig.Client.fov());
    }

    void enable() {
        this.enabled = true;
        this.modifier.enable();
        ClientUtil.playerEyePos(this.pos);
        this.posO.set((Vector3fc)this.pos);
        ClientUtil.disableBobView();
        ClientUtil.toThirdView();
    }

    public void disable() {
        this.enabled = false;
        this.modifier.disable();
        ClientUtil.resetBobView();
        ClientUtil.resetCameraType();
    }

    @SubscribeEvent
    public static void keyPress(ClientTickEvent.Post event) {
        while (((KeyMapping)ModKeyMapping.ZOOM_MODE.get()).consumeClick()) {
            if (ZoomPlugin.instance.enabled) {
                instance.disable();
                continue;
            }
            instance.enable();
        }
    }

    @SubscribeEvent
    public static void movementInputUpdate(MovementInputUpdateEvent event) {
        if (!ZoomPlugin.instance.enabled) {
            return;
        }
        ZoomPlugin.instance.forward.zero();
        ClientInput clientInput = event.getInput();
        Input input = clientInput.keyPresses;
        ZoomPlugin.instance.forward.add(input.left() ? 1.0f : 0.0f, input.jump() ? 1.0f : 0.0f, input.forward() ? 1.0f : 0.0f);
        ZoomPlugin.instance.forward.sub(input.right() ? 1.0f : 0.0f, input.shift() ? 1.0f : 0.0f, input.backward() ? 1.0f : 0.0f);
        clientInput.moveVector = Vec2.ZERO;
        clientInput.keyPresses = Input.EMPTY;
    }

    private static boolean disabled() {
        return !ZoomPlugin.instance.enabled || ClientUtil.hasScreen();
    }

    @SubscribeEvent
    public static void mouseClicking(InputEvent.MouseButton.Pre event) {
        if (ZoomPlugin.disabled()) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void mouseScrolling(InputEvent.MouseScrollingEvent event) {
        if (ZoomPlugin.disabled()) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        if (!ZoomPlugin.instance.enabled || ClientUtil.gamePaused()) {
            return;
        }
        ZoomPlugin.instance.forward.rotateY(-ClientUtil.playerYHeadRot() * ((float)Math.PI / 180)).mul(ZoomConfig.Client.speed());
        Vector3f oldPos = ZoomPlugin.instance.posO;
        Vector3f newPos = ZoomPlugin.instance.pos;
        oldPos.set((Vector3fc)newPos);
        newPos.add((Vector3fc)ZoomPlugin.instance.forward);
        if (!ZoomConfig.Server.blockCollision() || oldPos.equals((Object)newPos)) {
            return;
        }
        ClientLevel level = ClientUtil.clientLevel();
        float length = 0.1f;
        Vec3 from = new Vec3(oldPos);
        Vec3 to = new Vec3(ZoomPlugin.extend(oldPos, newPos, length));
        for (int i = 0; i < 3; ++i) {
            BlockHitResult blockHitResult = level.clipIncludingBorder(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
            if (blockHitResult.getType() != HitResult.Type.BLOCK) {
                return;
            }
            Vec3 hitPoint = blockHitResult.getLocation();
            switch (blockHitResult.getDirection()) {
                case DOWN: {
                    from = new Vec3(hitPoint.x, hitPoint.y - (double)length, hitPoint.z);
                    to = new Vec3(ZoomPlugin.extend((float)from.x, (float)from.y, (float)from.z, (float)to.x, (float)from.y, (float)to.z, length));
                    break;
                }
                case UP: {
                    from = new Vec3(hitPoint.x, hitPoint.y + (double)length, hitPoint.z);
                    to = new Vec3(ZoomPlugin.extend((float)from.x, (float)from.y, (float)from.z, (float)to.x, (float)from.y, (float)to.z, length));
                    break;
                }
                case NORTH: {
                    from = new Vec3(hitPoint.x, hitPoint.y, hitPoint.z - (double)length);
                    to = new Vec3(ZoomPlugin.extend((float)from.x, (float)from.y, (float)from.z, (float)to.x, (float)to.y, (float)from.z, length));
                    break;
                }
                case SOUTH: {
                    from = new Vec3(hitPoint.x, hitPoint.y, hitPoint.z + (double)length);
                    to = new Vec3(ZoomPlugin.extend((float)from.x, (float)from.y, (float)from.z, (float)to.x, (float)to.y, (float)from.z, length));
                    break;
                }
                case WEST: {
                    from = new Vec3(hitPoint.x - (double)length, hitPoint.y, hitPoint.z);
                    to = new Vec3(ZoomPlugin.extend((float)from.x, (float)from.y, (float)from.z, (float)from.x, (float)to.y, (float)to.z, length));
                    break;
                }
                case EAST: {
                    from = new Vec3(hitPoint.x + (double)length, hitPoint.y, hitPoint.z);
                    to = new Vec3(ZoomPlugin.extend((float)from.x, (float)from.y, (float)from.z, (float)from.x, (float)to.y, (float)to.z, length));
                }
            }
            if (Double.isNaN(to.x)) {
                newPos.set(from.x, from.y, from.z);
                return;
            }
            newPos.set(to.x, to.y, to.z);
        }
    }

    private static Vector3f extend(Vector3f from, Vector3f to, float length) {
        return new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize(length).add((Vector3fc)to);
    }

    private static Vector3f extend(float x1, float y1, float z1, float x2, float y2, float z2, float length) {
        return new Vector3f(x2, y2, z2).sub(x1, y1, z1).normalize(length).add(x2, y2, z2);
    }

    @SubscribeEvent
    public static void loggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        instance.disable();
    }

    public static boolean enabled() {
        return ZoomPlugin.instance.enabled;
    }
}

