/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi;

import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public final class ClientUtil {
    private static final Minecraft MC = Minecraft.getInstance();
    private static CameraType cameraType = CameraType.FIRST_PERSON;
    private static boolean bobView = false;

    public static Minecraft mc() {
        return MC;
    }

    public static LocalPlayer player() {
        return ClientUtil.MC.player;
    }

    public static Vector3f playerPos(Vector3f dest) {
        float partialTicks = ClientUtil.partialTicks();
        LocalPlayer player = ClientUtil.player();
        double x = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX());
        double y = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY());
        double z = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ());
        return dest.set(x, y, z);
    }

    public static float partialTicks() {
        return MC.getTimer().getGameTimeDeltaPartialTick(true);
    }

    public static Vector3f playerEyePos(Vector3f dest) {
        float partialTicks = ClientUtil.partialTicks();
        LocalPlayer player = ClientUtil.player();
        double x = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX());
        double y = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + (double)player.getEyeHeight();
        double z = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ());
        return dest.set(x, y, z);
    }

    public static Vector3f playerView(Vector3f dest) {
        LocalPlayer player = ClientUtil.player();
        float f = player.getXRot() * ((float)Math.PI / 180);
        float f1 = -player.getYRot() * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return dest.set(f3 * f4, -f5, f2 * f4);
    }

    public static float playerYHeadRot() {
        return Mth.wrapDegrees((float)ClientUtil.player().getYHeadRot());
    }

    public static float playerXRot() {
        return Mth.wrapDegrees((float)ClientUtil.player().getXRot());
    }

    public static boolean hideGui() {
        return ClientUtil.MC.options.hideGui;
    }

    public static boolean gamePaused() {
        return MC.isPaused();
    }

    public static void pushGuiLayer(Screen screen) {
        MC.pushGuiLayer(screen);
    }

    public static void popGuiLayer() {
        MC.popGuiLayer();
    }

    public static void toThirdView() {
        Options options = ClientUtil.MC.options;
        cameraType = options.getCameraType();
        options.setCameraType(CameraType.THIRD_PERSON_BACK);
    }

    public static void resetCameraType() {
        ClientUtil.MC.options.setCameraType(cameraType);
    }

    public static Font font() {
        return ClientUtil.MC.font;
    }

    public static void disableBobView() {
        Options options = ClientUtil.MC.options;
        bobView = (Boolean)options.bobView().get();
        options.bobView().set((Object)false);
    }

    public static void resetBobView() {
        ClientUtil.MC.options.bobView().set((Object)bobView);
    }

    public static int fov() {
        return (Integer)ClientUtil.MC.options.fov().get();
    }

    public static ClientLevel clientLevel() {
        return ClientUtil.MC.level;
    }

    public static boolean hasScreen() {
        return ClientUtil.MC.screen != null;
    }

    public static Camera camera() {
        return ClientUtil.MC.gameRenderer.getMainCamera();
    }

    public static GameRenderer gameRenderer() {
        return ClientUtil.MC.gameRenderer;
    }

    public static float fovEffectScale() {
        return ((Double)ClientUtil.MC.options.fovEffectScale().get()).floatValue();
    }
}

