/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.core;

import cn.anecansaitin.freecameraapi.ClientUtil;
import cn.anecansaitin.freecameraapi.core.ModifierManager;
import cn.anecansaitin.freecameraapi.core.ModifierRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(modid="free_camera_api", value={Dist.CLIENT})
public class ManagerTicker {
    public static void tick() {
        Camera camera = ClientUtil.camera();
        camera.setFov(ManagerTicker.getFov(camera));
        ModifierRegistry.INSTANCE.updateController();
        ModifierManager.INSTANCE.modify();
    }

    private static float getFov(Camera camera) {
        FogType fogtype;
        float partialTick = camera.getPartialTickTime();
        GameRenderer gameRenderer = ClientUtil.gameRenderer();
        double fov = ClientUtil.fov();
        fov *= (double)Mth.lerp((float)partialTick, (float)gameRenderer.oldFov, (float)gameRenderer.fov);
        if (camera.getEntity() instanceof LivingEntity && ((LivingEntity)camera.getEntity()).isDeadOrDying()) {
            float f = Math.min((float)((LivingEntity)camera.getEntity()).deathTime + partialTick, 20.0f);
            fov /= (double)((1.0f - 500.0f / (f + 500.0f)) * 2.0f + 1.0f);
        }
        if ((fogtype = camera.getFluidInCamera()) == FogType.LAVA || fogtype == FogType.WATER) {
            fov *= Mth.lerp((double)ClientUtil.fovEffectScale(), (double)1.0, (double)0.8571428656578064);
        }
        return (float)fov;
    }

    @SubscribeEvent
    public static void computeFov(ViewportEvent.ComputeFov event) {
        if (!ModifierManager.INSTANCE.isStateEnabledAnd(9)) {
            return;
        }
        event.setFOV((double)ClientUtil.camera().getFov());
    }
}

