/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.core;

import cn.anecansaitin.freecameraapi.api.ICameraModifier;
import cn.anecansaitin.freecameraapi.api.ObstacleHandler;
import cn.anecansaitin.freecameraapi.api.extension.ControlScheme;
import cn.anecansaitin.freecameraapi.api.extension.ICameraModifierExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Modifier
implements ICameraModifier,
ICameraModifierExtension {
    private final ResourceLocation id;
    private final Vector3f pos = new Vector3f();
    private final Vector3f rot = new Vector3f();
    private float fov;
    private int state;
    private ObstacleHandler obstacleHandler;
    private ControlScheme controlScheme = ControlScheme.VANILLA;

    public Modifier(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public Modifier enablePos() {
        this.state |= 2;
        return this;
    }

    @Override
    public Modifier disablePos() {
        this.state &= 0xFFFFFFFD;
        return this;
    }

    @Override
    public Modifier setPos(float x, float y, float z) {
        this.pos.set(x, y, z);
        return this;
    }

    @Override
    public Modifier setPos(Vector3f pos) {
        return this.setPos(pos.x, pos.y, pos.z);
    }

    @Override
    public Modifier addPos(float x, float y, float z) {
        this.pos.add(x, y, z);
        return this;
    }

    @Override
    public Modifier addPos(Vector3f pos) {
        return this.addPos(pos.x, pos.y, pos.z);
    }

    @Override
    public Modifier enableRotation() {
        this.state |= 4;
        return this;
    }

    @Override
    public Modifier disableRotation() {
        this.state &= 0xFFFFFFFB;
        return this;
    }

    @Override
    public Modifier setRotationYXZ(float xRot, float yRot, float zRot) {
        this.rot.set(xRot, yRot, zRot);
        return this;
    }

    @Override
    public Modifier setRotationYXZ(Vector3f rot) {
        return this.setRotationYXZ(rot.x, rot.y, rot.z);
    }

    @Override
    public Modifier setRotationZYX(float xRot, float yRot, float zRot) {
        return this.setRotationYXZ(this.eulerZYXToYXZ(xRot, yRot, zRot));
    }

    @Override
    public Modifier setRotationZYX(Vector3f rot) {
        return this.setRotationYXZ(this.eulerZYXToYXZ(rot.x, rot.y, rot.z));
    }

    @Override
    public Modifier rotateYXZ(float xRot, float yRot, float zRot) {
        this.rot.add(xRot, yRot, zRot);
        return this;
    }

    private Vector3f eulerZYXToYXZ(float x, float y, float z) {
        return new Quaternionf().rotationZYX(z *= (float)Math.PI / 180, y *= (float)Math.PI / 180, x *= (float)Math.PI / 180).getEulerAnglesYXZ(new Vector3f()).mul(57.295776f);
    }

    @Override
    public Modifier enableFov() {
        this.state |= 8;
        return this;
    }

    @Override
    public Modifier disableFov() {
        this.state &= 0xFFFFFFF7;
        return this;
    }

    @Override
    public Modifier setFov(float fov) {
        this.fov = fov;
        return this;
    }

    @Override
    public Modifier move(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z).rotateX(this.rot.x * ((float)Math.PI / 180)).rotateY(-this.rot.y * ((float)Math.PI / 180)).rotateZ(this.rot.z * ((float)Math.PI / 180));
        this.pos.add((Vector3fc)vec);
        return this;
    }

    @Override
    public Modifier aimAt(float x, float y, float z) {
        Vector3f aim = new Vector3f(x - this.pos.x, y - this.pos.y, z - this.pos.z);
        this.rot.x = org.joml.Math.acos((float)(org.joml.Math.sqrt((float)(aim.x * aim.x + aim.z * aim.z)) / aim.length())) * 57.295776f * (float)(aim.y < 0.0f ? 1 : -1);
        this.rot.y = (float)(-(Mth.atan2((double)aim.x, (double)aim.z) * 57.2957763671875));
        return this;
    }

    @Override
    public Vector3f getPos() {
        return this.pos;
    }

    @Override
    public Vector3f getRot() {
        return this.rot;
    }

    @Override
    public float getFov() {
        return this.fov;
    }

    @Override
    public Modifier enable() {
        this.state |= 1;
        return this;
    }

    @Override
    public Modifier disable() {
        this.state &= 0xFFFFFFFE;
        return this;
    }

    @Override
    public ICameraModifier disableAll() {
        this.state = 0;
        return this;
    }

    @Override
    public Modifier enableGlobalMode() {
        this.state |= 0x20;
        return this;
    }

    @Override
    public Modifier disableGlobalMode() {
        this.state &= 0xFFFFFFDF;
        return this;
    }

    @Override
    public ICameraModifier enableObstacle() {
        this.state |= 0x10;
        this.obstacleHandler = ObstacleHandler.NULL;
        return this;
    }

    @Override
    public ICameraModifier enableObstacle(@NotNull ObstacleHandler handler) {
        this.state |= 0x10;
        this.obstacleHandler = handler;
        return this;
    }

    @Override
    public ICameraModifier disableObstacle() {
        this.state &= 0xFFFFFFEF;
        return this;
    }

    @Override
    public ObstacleHandler getObstacleHandler() {
        return this.obstacleHandler;
    }

    @Override
    public ICameraModifier setToVanilla() {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 position = camera.getPosition();
        if (this.isStateEnabledOr(32)) {
            this.pos.set(position.x, position.y, position.z);
            this.rot.set(camera.getXRot(), camera.getYRot(), camera.getRoll());
        } else {
            LocalPlayer player = Minecraft.getInstance().player;
            Vec3 playerPos = player.getPosition(camera.getPartialTickTime());
            this.pos.set(position.x - playerPos.x, position.y - playerPos.y, position.z - playerPos.z);
            this.rot.set(camera.getXRot(), camera.getYRot(), camera.getRoll());
        }
        this.fov = camera.getFov();
        return this;
    }

    @Override
    public ICameraModifier clean() {
        this.pos.zero();
        this.rot.zero();
        this.fov = 0.0f;
        return this;
    }

    @Override
    public ICameraModifier reset() {
        this.disableAll();
        this.clean();
        return this;
    }

    @Override
    public ICameraModifier setState(int state) {
        this.state = state;
        return this;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ICameraModifierExtension enableChunkLoader() {
        this.state |= 0x80;
        return this;
    }

    @Override
    public ICameraModifierExtension disableChunkLoader() {
        this.state &= 0xFFFFFF7F;
        return this;
    }

    @Override
    public ICameraModifierExtension setControlScheme(ControlScheme controlScheme) {
        this.controlScheme = controlScheme;
        return this;
    }

    @Override
    public ControlScheme getControlScheme() {
        return this.controlScheme;
    }
}

