/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.api;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CameraStates {
    public static final int ENABLE;
    public static final int POS;
    public static final int ROT;
    public static final int FOV;
    public static final int OBSTACLE;
    public static final int GLOBAL_MODE;
    public static final Object2IntOpenHashMap<String> NAME_STATE;
    public static final Int2ObjectOpenHashMap<String> STATE_NAMES;
    private static int COUNTER;

    public static int nextState(String name) {
        if (NAME_STATE.containsKey((Object)name)) {
            throw new IllegalArgumentException("State name already exists: " + name);
        }
        NAME_STATE.put((Object)name, COUNTER <<= 1);
        STATE_NAMES.put(COUNTER, (Object)name);
        return COUNTER;
    }

    public static int getState(String name) {
        return NAME_STATE.getInt((Object)name);
    }

    public static String getName(int state) {
        return (String)STATE_NAMES.get(state);
    }

    public static MutableComponent getTranslation(String name) {
        return Component.translatable((String)("free_camera_api.state." + name));
    }

    public static MutableComponent getTranslation(int state) {
        return CameraStates.getTranslation(CameraStates.getName(state));
    }

    static {
        NAME_STATE = new Object2IntOpenHashMap();
        STATE_NAMES = new Int2ObjectOpenHashMap();
        COUNTER = 1;
        NAME_STATE.defaultReturnValue(-1);
        STATE_NAMES.defaultReturnValue((Object)"Undefined");
        ENABLE = 1;
        NAME_STATE.put((Object)"enable", ENABLE);
        STATE_NAMES.put(ENABLE, (Object)"enable");
        POS = CameraStates.nextState("pos");
        ROT = CameraStates.nextState("rot");
        FOV = CameraStates.nextState("fov");
        OBSTACLE = CameraStates.nextState("obstacle");
        GLOBAL_MODE = CameraStates.nextState("global_mode");
    }
}

