/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.core;

import cn.anecansaitin.freecameraapi.ClientUtil;
import cn.anecansaitin.freecameraapi.api.CameraStates;
import cn.anecansaitin.freecameraapi.core.ModifierManager;
import cn.anecansaitin.freecameraapi.core.ModifierRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(modid="free_camera_api", value={Dist.CLIENT})
public class ManagerTicker {
    public static void tick() {
        Camera camera = ClientUtil.camera();
        camera.setFov(ManagerTicker.getFov(camera));
        ModifierRegistry.INSTANCE.updateController();
        ModifierManager.INSTANCE.modify();
    }

    private static float getFov(Camera camera) {
        FogType fogtype;
        LivingEntity livingentity;
        float partialTick = camera.getPartialTickTime();
        GameRenderer gameRenderer = ClientUtil.gameRenderer();
        float f = ClientUtil.fov();
        f *= Mth.lerp((float)partialTick, (float)gameRenderer.oldFovModifier, (float)gameRenderer.fovModifier);
        Entity entity = camera.entity();
        if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity).isDeadOrDying()) {
            float f1 = Math.min((float)livingentity.deathTime + partialTick, 20.0f);
            f /= (1.0f - 500.0f / (f1 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((fogtype = camera.getFluidInCamera()) == FogType.LAVA || fogtype == FogType.WATER) {
            float f2 = ClientUtil.fovEffectScale();
            f *= Mth.lerp((float)f2, (float)1.0f, (float)0.85714287f);
        }
        return f;
    }

    @SubscribeEvent
    public static void computeFov(ViewportEvent.ComputeFov event) {
        if (!ModifierManager.INSTANCE.isStateEnabledAnd(CameraStates.FOV | CameraStates.ENABLE)) {
            return;
        }
        event.setFOV(ClientUtil.camera().getFov());
    }
}

