/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.core;

import cn.anecansaitin.freecameraapi.ClientUtil;
import cn.anecansaitin.freecameraapi.api.CameraStates;
import cn.anecansaitin.freecameraapi.api.ICameraModifier;
import cn.anecansaitin.freecameraapi.api.ObstacleHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Modifier
implements ICameraModifier {
    private final Identifier id;
    private final Vector3f pos = new Vector3f();
    private final Vector3f rot = new Vector3f();
    private float fov;
    private int state;
    private ObstacleHandler obstacleHandler;

    public Modifier(Identifier id) {
        this.id = id;
    }

    @Override
    public Modifier enablePos() {
        this.state |= CameraStates.POS;
        return this;
    }

    @Override
    public Modifier disablePos() {
        this.state &= ~CameraStates.POS;
        return this;
    }

    @Override
    public Modifier setPos(float x, float y, float z) {
        this.pos.set(x, y, z);
        return this;
    }

    @Override
    public Modifier setPos(Vector3f pos) {
        return this.setPos(pos.x, pos.y, pos.z);
    }

    @Override
    public Modifier addPos(float x, float y, float z) {
        this.pos.add(x, y, z);
        return this;
    }

    @Override
    public Modifier addPos(Vector3f pos) {
        return this.addPos(pos.x, pos.y, pos.z);
    }

    @Override
    public Modifier enableRotation() {
        this.state |= CameraStates.ROT;
        return this;
    }

    @Override
    public Modifier disableRotation() {
        this.state &= ~CameraStates.ROT;
        return this;
    }

    @Override
    public Modifier setRotationYXZ(float xRot, float yRot, float zRot) {
        this.rot.set(xRot, yRot, zRot);
        return this;
    }

    @Override
    public Modifier setRotationYXZ(Vector3f rot) {
        return this.setRotationYXZ(rot.x, rot.y, rot.z);
    }

    @Override
    public Modifier setRotationZYX(float xRot, float yRot, float zRot) {
        return this.setRotationYXZ(this.eulerZYXToYXZ(xRot, yRot, zRot));
    }

    @Override
    public Modifier setRotationZYX(Vector3f rot) {
        return this.setRotationYXZ(this.eulerZYXToYXZ(rot.x, rot.y, rot.z));
    }

    @Override
    public Modifier rotateYXZ(float xRot, float yRot, float zRot) {
        this.rot.add(xRot, yRot, zRot);
        return this;
    }

    private Vector3f eulerZYXToYXZ(float x, float y, float z) {
        return new Quaternionf().rotationZYX(z *= (float)Math.PI / 180, y *= (float)Math.PI / 180, x *= (float)Math.PI / 180).getEulerAnglesYXZ(new Vector3f()).mul(57.295776f);
    }

    @Override
    public Modifier enableFov() {
        this.state |= CameraStates.FOV;
        return this;
    }

    @Override
    public Modifier disableFov() {
        this.state &= ~CameraStates.FOV;
        return this;
    }

    @Override
    public Modifier setFov(float fov) {
        this.fov = fov;
        return this;
    }

    @Override
    public Modifier move(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z).rotateX(this.rot.x * ((float)Math.PI / 180)).rotateY(-this.rot.y * ((float)Math.PI / 180)).rotateZ(this.rot.z * ((float)Math.PI / 180));
        this.pos.add((Vector3fc)vec);
        return this;
    }

    @Override
    public Modifier aimAt(float x, float y, float z) {
        Vector3f aim = new Vector3f(x - this.pos.x, y - this.pos.y, z - this.pos.z);
        this.rot.x = org.joml.Math.acos((float)(org.joml.Math.sqrt((float)(aim.x * aim.x + aim.z * aim.z)) / aim.length())) * 57.295776f * (float)(aim.y < 0.0f ? 1 : -1);
        this.rot.y = (float)(-(Mth.atan2((double)aim.x, (double)aim.z) * 57.2957763671875));
        return this;
    }

    @Override
    public Vector3f getPos() {
        return this.pos;
    }

    @Override
    public Vector3f getRot() {
        return this.rot;
    }

    @Override
    public float getFov() {
        return this.fov;
    }

    @Override
    public Modifier enable() {
        this.state |= CameraStates.ENABLE;
        return this;
    }

    @Override
    public Modifier disable() {
        this.state &= ~CameraStates.ENABLE;
        return this;
    }

    @Override
    public ICameraModifier disableAll() {
        this.state = 0;
        return this;
    }

    @Override
    public Modifier enableGlobalMode() {
        this.state |= CameraStates.GLOBAL_MODE;
        return this;
    }

    @Override
    public Modifier disableGlobalMode() {
        this.state &= ~CameraStates.GLOBAL_MODE;
        return this;
    }

    @Override
    public ICameraModifier enableObstacle() {
        this.state |= CameraStates.OBSTACLE;
        this.obstacleHandler = ObstacleHandler.NULL;
        return this;
    }

    @Override
    public ICameraModifier enableObstacle(@NotNull ObstacleHandler handler) {
        this.state |= CameraStates.OBSTACLE;
        this.obstacleHandler = handler;
        return this;
    }

    @Override
    public ICameraModifier disableObstacle() {
        this.state &= ~CameraStates.OBSTACLE;
        return this;
    }

    @Override
    public ObstacleHandler getObstacleHandler() {
        return this.obstacleHandler;
    }

    @Override
    public ICameraModifier setToVanilla() {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 position = camera.position();
        if (this.isStateEnabledOr(CameraStates.GLOBAL_MODE)) {
            this.pos.set(position.x, position.y, position.z);
            this.rot.set(camera.xRot(), camera.yRot(), camera.getRoll());
        } else {
            Vec3 playerPos = ClientUtil.player().getPosition(camera.getPartialTickTime());
            this.pos.set(position.x - playerPos.x, position.y - playerPos.y, position.z - playerPos.z);
            this.rot.set(camera.xRot(), camera.yRot(), camera.getRoll());
        }
        this.fov = camera.getFov();
        return this;
    }

    @Override
    public ICameraModifier clean() {
        this.pos.zero();
        this.rot.zero();
        this.fov = 0.0f;
        return this;
    }

    @Override
    public ICameraModifier reset() {
        this.disableAll();
        this.clean();
        return this;
    }

    @Override
    public ICameraModifier setState(int state) {
        this.state = state;
        return this;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public Identifier getId() {
        return this.id;
    }
}

