/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.core;

import cn.anecansaitin.freecameraapi.api.CameraStates;
import cn.anecansaitin.freecameraapi.api.ICameraModifier;
import cn.anecansaitin.freecameraapi.api.ObstacleHandler;
import cn.anecansaitin.freecameraapi.core.ModifierRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModifierManager {
    public static final ModifierManager INSTANCE = new ModifierManager();
    private final Vector3f pos;
    private final Vector3f rot;
    private float fov;
    private int state;
    private final float[] fovDest = new float[1];

    private ModifierManager() {
        this.pos = new Vector3f();
        this.rot = new Vector3f();
    }

    public void modify() {
        this.setToVanilla();
        this.applyToCamera();
    }

    private void setToVanilla() {
        Camera camera = this.camera();
        Vec3 cameraPos = camera.position();
        this.pos.set(cameraPos.x, cameraPos.y, cameraPos.z);
        this.rot.set(camera.xRot(), camera.yRot() % 360.0f, camera.getRoll());
        this.fov = this.camera().getFov();
    }

    private void applyToCamera() {
        ICameraModifier modifier = ModifierRegistry.INSTANCE.getActiveModifier();
        if (modifier == null) {
            this.state = 0;
            return;
        }
        this.state = modifier.getState();
        this.applyPos(modifier);
        this.applyRot(modifier);
        this.applyFov(modifier);
        this.applyGlobal(modifier);
        this.applyObstacle(modifier);
        this.setCamera();
    }

    private void applyPos(ICameraModifier modifier) {
        if (!modifier.isStateEnabledOr(CameraStates.POS)) {
            return;
        }
        this.pos.set((Vector3fc)modifier.getPos());
    }

    private void applyRot(ICameraModifier modifier) {
        if (!modifier.isStateEnabledOr(CameraStates.ROT)) {
            return;
        }
        this.rot.set((Vector3fc)modifier.getRot());
    }

    private void applyFov(ICameraModifier modifier) {
        if (!modifier.isStateEnabledOr(CameraStates.FOV)) {
            return;
        }
        this.fov = modifier.getFov();
    }

    private void applyGlobal(ICameraModifier modifier) {
        if (modifier.isStateEnabledOr(CameraStates.GLOBAL_MODE)) {
            return;
        }
        if (modifier.isStateEnabledOr(CameraStates.POS)) {
            Vec3 playerPos = this.player().getPosition(this.camera().getPartialTickTime());
            this.pos.add((float)playerPos.x, (float)playerPos.y, (float)playerPos.z);
        }
    }

    private void applyObstacle(ICameraModifier modifier) {
        if (!modifier.isStateEnabledOr(CameraStates.OBSTACLE)) {
            return;
        }
        ObstacleHandler obstacleHandler = modifier.getObstacleHandler();
        this.fovDest[0] = this.fov;
        switch (obstacleHandler.obstacleAvoid(this.pos, this.rot, this.fovDest)) {
            case PASS: {
                this.defaultObstacle(obstacleHandler);
                break;
            }
            case COLLIDE: {
                this.fov = this.fovDest[0];
                obstacleHandler.onCollision(this.pos, this.rot, this.fov);
                break;
            }
        }
    }

    private void defaultObstacle(ObstacleHandler obstacleHandler) {
        float max;
        Vector3f origin = this.player().getEyePosition(this.camera().getPartialTickTime()).toVector3f();
        Vector3f direction = this.pos.sub((Vector3fc)origin, new Vector3f());
        float size = 0.1f;
        float length = max = direction.length();
        for (int i = 0; i < 8; ++i) {
            float distance;
            float x = size * (float)((i & 1) * 2 - 1);
            float y = size * (float)((i >> 1 & 1) * 2 - 1);
            float z = size * (float)((i >> 2 & 1) * 2 - 1);
            Vec3 begin = new Vec3((double)(origin.x + x), (double)(origin.y + y), (double)(origin.z + z));
            Vec3 end = new Vec3((double)(this.pos.x + x), (double)(this.pos.y + y), (double)(this.pos.z + z));
            BlockHitResult hitresult = this.player().level().clip(new ClipContext(begin, end, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)this.player()));
            if (hitresult.getType() == HitResult.Type.MISS || !((distance = (float)hitresult.getLocation().distanceToSqr((double)origin.x, (double)origin.y, (double)origin.z)) < Mth.square((float)max))) continue;
            max = Mth.sqrt((float)distance);
        }
        if (max == length) {
            return;
        }
        this.pos.set((Vector3fc)direction.normalize(max).add((Vector3fc)origin));
        obstacleHandler.onCollision(this.pos, this.rot, this.fov);
    }

    private void setCamera() {
        Camera camera = this.camera();
        camera.setRotation(this.rot.y, this.rot.x, this.rot.z);
        camera.setPosition((double)this.pos.x, (double)this.pos.y, (double)this.pos.z);
        camera.setFov(this.fov);
    }

    private Camera camera() {
        return Minecraft.getInstance().gameRenderer.getMainCamera();
    }

    private LocalPlayer player() {
        return Minecraft.getInstance().player;
    }

    public Vector3f pos() {
        return this.pos;
    }

    public Vector3f rot() {
        return this.rot;
    }

    public float fov() {
        return this.fov;
    }

    public boolean isStateEnabledAnd(int mask) {
        return (this.state & mask) == mask;
    }

    public boolean isStateEnabledOr(int mask) {
        return (this.state & mask) != 0;
    }
}

