/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.freecameraapi.starup;

import cn.anecansaitin.freecameraapi.api.CameraPlugin;
import cn.anecansaitin.freecameraapi.api.CameraState;
import cn.anecansaitin.freecameraapi.api.ICameraPlugin;
import cn.anecansaitin.freecameraapi.api.ModifierPriority;
import cn.anecansaitin.freecameraapi.core.ModifierRegistry;
import cn.anecansaitin.freecameraapi.starup.CameraPluginInitializeException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.resources.Identifier;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import oshi.util.tuples.Triplet;

public final class AnnotationFinder {
    public static void clientLoading() {
        AnnotationFinder.loadState();
        AnnotationFinder.loadPlugin();
    }

    public static void commonLoading() {
        AnnotationFinder.loadState();
    }

    private static void loadState() {
        try {
            for (String clazz : AnnotationFinder.findState()) {
                Class.forName(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Collection<String> findState() {
        Type type = Type.getType(CameraState.class);
        TreeMap<String, String> stateClass = new TreeMap<String, String>();
        List allScanData = ModList.get().getAllScanData();
        int allScanDataSize = allScanData.size();
        block0: for (int i = 0; i < allScanDataSize; ++i) {
            ModFileScanData data = (ModFileScanData)allScanData.get(i);
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                if (!annotation.annotationType().equals((Object)type)) continue;
                String namespace = ((IModInfo)ModList.get().getMods().get(i)).getNamespace();
                String className = annotation.memberName();
                stateClass.put(namespace, className);
                continue block0;
            }
        }
        return stateClass.values();
    }

    private static void loadPlugin() {
        for (Triplet<Identifier, ICameraPlugin, ModifierPriority> triplet : AnnotationFinder.findPlugin()) {
            ModifierRegistry.INSTANCE.register((Identifier)triplet.getA(), (ICameraPlugin)triplet.getB(), (ModifierPriority)((Object)triplet.getC()));
        }
    }

    private static List<Triplet<Identifier, ICameraPlugin, ModifierPriority>> findPlugin() {
        Type type = Type.getType(CameraPlugin.class);
        ArrayList<Triplet<Identifier, ICameraPlugin, ModifierPriority>> plugins = new ArrayList<Triplet<Identifier, ICameraPlugin, ModifierPriority>>();
        List allScanData = ModList.get().getAllScanData();
        boolean dev = !FMLEnvironment.isProduction();
        int allScanDataSize = allScanData.size();
        block4: for (int i = 0; i < allScanDataSize; ++i) {
            ModFileScanData data = (ModFileScanData)allScanData.get(i);
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                if (!annotation.annotationType().equals((Object)type)) continue;
                String name = null;
                try {
                    String value = annotation.annotationData().get("value").toString();
                    if (!dev && value.equals("dev")) continue;
                    String namespace = ((IModInfo)ModList.get().getMods().get(i)).getNamespace();
                    Identifier id = Identifier.fromNamespaceAndPath((String)namespace, (String)value);
                    ModAnnotation.EnumHolder priorityHolder = (ModAnnotation.EnumHolder)annotation.annotationData().get("priority");
                    ModifierPriority priority = ModifierPriority.NORMAL;
                    if (priorityHolder != null) {
                        priority = ModifierPriority.valueOf(priorityHolder.value());
                    }
                    name = annotation.memberName();
                    ICameraPlugin plugin = Class.forName(name).asSubclass(ICameraPlugin.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    plugins.add((Triplet<Identifier, ICameraPlugin, ModifierPriority>)new Triplet((Object)id, (Object)plugin, (Object)priority));
                    continue block4;
                }
                catch (ClassNotFoundException e) {
                    throw CameraPluginInitializeException.classNotFound(name);
                }
                catch (NoSuchMethodException e) {
                    throw CameraPluginInitializeException.noSuchMethod(name);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw CameraPluginInitializeException.invocationTarget(name);
                }
            }
        }
        return plugins;
    }
}

