/*
 * Decompiled with CFR 0.152.
 */
package org.crazyhouse.pinkwoolblocker;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Pinkwoolblocker
extends JavaPlugin
implements Listener {
    private final HashMap<UUID, Integer> warningCount = new HashMap();
    private final int MAX_WARNINGS = 5;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Pinkwoolblocker enabled!");
    }

    public void onDisable() {
        this.getLogger().info("Pinkwoolblocker disabled!");
    }

    private void warnPlayer(Player player, String message) {
        UUID uuid = player.getUniqueId();
        int count = this.warningCount.getOrDefault(uuid, 0) + 1;
        this.warningCount.put(uuid, count);
        player.sendMessage(ChatColor.RED + message);
        if (count > 5) {
            player.kickPlayer(ChatColor.RED + "Kicked for attempting to dye pink items too many times!");
            this.warningCount.remove(uuid);
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        Material type;
        ItemStack result = event.getCurrentItem();
        if (result == null) {
            return;
        }
        boolean usesPinkDye = false;
        for (ItemStack item : event.getInventory().getContents()) {
            if (item == null || item.getType() != Material.PINK_DYE) continue;
            usesPinkDye = true;
            break;
        }
        if ((type = result.getType()) == Material.PINK_WOOL) {
            event.setCancelled(true);
            this.warnPlayer((Player)event.getWhoClicked(), "Pink wool cannot be crafted!");
        }
        if (usesPinkDye && (type.toString().endsWith("_BED") || type.toString().endsWith("_WOOL"))) {
            event.setCancelled(true);
            this.warnPlayer((Player)event.getWhoClicked(), "Pink dye cannot be used to craft this item!");
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || event.getCursor() == null) {
            return;
        }
        ItemStack clicked = event.getCurrentItem();
        ItemStack cursor = event.getCursor();
        if (event.getInventory().getType() == InventoryType.LOOM) {
            ItemStack dyeItem = event.getInventory().getItem(1);
            ItemStack dyeableItem = event.getInventory().getItem(0);
            if (dyeItem != null && dyeableItem != null && dyeItem.getType() == Material.PINK_DYE && (dyeableItem.getType().toString().endsWith("_WOOL") || dyeableItem.getType().toString().endsWith("_BED"))) {
                event.setCancelled(true);
                this.warnPlayer((Player)event.getWhoClicked(), "Pink dye cannot be applied to this item!");
            }
        }
        if (clicked.getType() == Material.PINK_DYE && (cursor.getType().toString().endsWith("_WOOL") || cursor.getType().toString().endsWith("_BED")) || cursor.getType() == Material.PINK_DYE && (clicked.getType().toString().endsWith("_WOOL") || clicked.getType().toString().endsWith("_BED"))) {
            event.setCancelled(true);
            this.warnPlayer((Player)event.getWhoClicked(), "Pink dye cannot be combined with this item!");
        }
    }

    @EventHandler
    public void onDyeSheep(PlayerInteractEntityEvent event) {
        if (event.getRightClicked().getType() == EntityType.SHEEP) {
            Sheep sheep = (Sheep)event.getRightClicked();
            Player player = event.getPlayer();
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item != null && item.getType() == Material.PINK_DYE) {
                event.setCancelled(true);
                this.warnPlayer(player, "You cannot dye sheep pink!");
            }
        }
    }
}

