/*
 * Decompiled with CFR 0.152.
 */
package Snattuw.playsoundnew.client;

import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PlaysoundClient
implements ClientModInitializer {
    private static final File CUSTOM_MUSIC_DIR = new File(class_310.method_1551().field_1697, "custom_music");
    private static final File RESOURCEPACK_DIR = new File(class_310.method_1551().field_1697, "resourcepacks");
    private static final File PACK_FOLDER = new File(RESOURCEPACK_DIR, "autogenerated_custom_music");
    private boolean isLooping = false;
    private String loopingSoundId;
    private float loopingPitch = 1.0f;
    private float loopingVolume = 1.0f;
    private class_1113 currentLoopingInstance;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    public static final boolean DEBUG = false;
    public static final int MAX_MUSIC_DELAY = -1;
    private static final SuggestionProvider<FabricClientCommandSource> SOUND_SUGGESTIONS = (context, builder) -> {
        class_310 client = class_310.method_1551();
        if (client.method_1483() == null) {
            return builder.buildFuture();
        }
        String input = builder.getRemaining().toLowerCase();
        for (class_2960 id : client.method_1483().method_4864()) {
            String namespace = id.method_12836().toLowerCase();
            String path = id.method_12832().toLowerCase();
            if (!namespace.contains(input) && !path.contains(input) && !id.toString().toLowerCase().contains(input)) continue;
            builder.suggest(id.toString());
        }
        return builder.buildFuture();
    };

    public void onInitializeClient() {
        this.setupCustomMusicFolder();
        this.generateResourcePack();
        this.enableResourcePackInOptions();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"playsound").then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests(SOUND_SUGGESTIONS).executes(context -> {
                String args = StringArgumentType.getString((CommandContext)context, (String)"args");
                String[] parts = args.split(" ");
                String soundId = parts[0];
                float pitch = parts.length > 1 ? this.parseFloat(parts[1], 1.0f) : 1.0f;
                float volume = parts.length > 2 ? this.parseFloat(parts[2], 1.0f) : 1.0f;
                boolean loop = parts.length > 3 && Boolean.parseBoolean(parts[3]);
                return this.playSoundCommand((CommandContext<FabricClientCommandSource>)context, soundId, pitch, volume, loop);
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stopsound").executes(context -> {
                this.isLooping = false;
                if (!this.scheduler.isShutdown()) {
                    this.scheduler.shutdownNow();
                }
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
                class_310 client = class_310.method_1551();
                if (client.method_1483() != null) {
                    client.method_1483().method_4881();
                    this.sendMsg((CommandContext<FabricClientCommandSource>)context, "\u00a7eStopped all sounds.");
                }
                return 1;
            }));
        });
    }

    private void setupCustomMusicFolder() {
        if (!CUSTOM_MUSIC_DIR.exists()) {
            CUSTOM_MUSIC_DIR.mkdirs();
            File howTo = new File(CUSTOM_MUSIC_DIR, "READ FIRST.txt");
            try (FileWriter writer = new FileWriter(howTo);){
                writer.write("If you want to use other than .ogg sound files you have to download FFmpeg! \nDownload the latest FFmpeg release from https://www.gyan.dev/ffmpeg/builds/ffmpeg-release-essentials.zip\nExtract the downloaded .zip file into your minecraft folder\nYou need to restart minecraft for new sounds to be applied. \nPlay your custom music with /playsound custom_music:<filename> [<pitch>] [<volume>] [<looping>]");
            }
            catch (IOException e) {
                System.err.println("Failed to write READ FIRST.txt: " + e.getMessage());
            }
        }
    }

    private void generateResourcePack() {
        FileWriter writer;
        if (PACK_FOLDER.exists()) {
            try {
                this.deleteFolder(PACK_FOLDER.toPath());
            }
            catch (IOException e) {
                System.err.println("Could not clear old resource pack folder: " + e.getMessage());
            }
        }
        File soundsDir = new File(PACK_FOLDER, "assets/custom_music/sounds");
        File mcmetaFile = new File(PACK_FOLDER, "pack.mcmeta");
        soundsDir.mkdirs();
        File[] soundFiles = CUSTOM_MUSIC_DIR.listFiles((dir, name) -> name.toLowerCase().endsWith(".mp3") || name.toLowerCase().endsWith(".wav"));
        if (soundFiles == null) {
            return;
        }
        LinkedHashMap soundsJson = new LinkedHashMap();
        for (File file : soundFiles) {
            if (!file.getName().toLowerCase().endsWith(".ogg")) {
                File convertedFile;
                file = convertedFile = this.convertToOgg(file);
            }
            try {
                Path dest = Paths.get(soundsDir.getAbsolutePath(), file.getName());
                Files.copy(file.toPath(), dest, StandardCopyOption.REPLACE_EXISTING);
                String nameWithoutExt = file.getName().replaceAll("\\.ogg$", "");
                LinkedHashMap<String, List<CallSite>> entry = new LinkedHashMap<String, List<CallSite>>();
                entry.put("sounds", Collections.singletonList("custom_music:" + nameWithoutExt));
                soundsJson.put(nameWithoutExt, entry);
            }
            catch (IOException e) {
                System.err.println("Failed to copy " + file.getName() + ": " + e.getMessage());
            }
        }
        try {
            writer = new FileWriter(new File(PACK_FOLDER, "assets/custom_music/sounds.json"));
            try {
                writer.write(new GsonBuilder().setPrettyPrinting().create().toJson(soundsJson));
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to write sounds.json: " + e.getMessage());
        }
        try {
            writer = new FileWriter(mcmetaFile);
            try {
                writer.write("{\n  \"pack\": {\n    \"pack_format\": 46,\n    \"description\": \"Auto-generated music pack\"\n  }\n}");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to write pack.mcmeta: " + e.getMessage());
        }
    }

    private File convertToOgg(File inputFile) {
        String outputFileName = inputFile.getName().replaceAll("\\.[^.]+$", ".ogg");
        File outputFile = new File(CUSTOM_MUSIC_DIR, outputFileName);
        String ffmpegCommand = String.format("\"%s\" -i \"%s\" -vn -acodec libvorbis -ar 44100 -ac 2 -ab 192k \"%s\"", this.findFFmpeg(), inputFile.getAbsolutePath(), outputFile.getAbsolutePath());
        try {
            Process process = Runtime.getRuntime().exec(ffmpegCommand);
            int exitCode = process.waitFor();
            this.printProcessOutput(process);
            if (exitCode == 0) {
                System.out.println("Successfully converted " + inputFile.getName() + " to .ogg.");
            } else {
                System.err.println("FFmpeg failed to convert " + inputFile.getName() + " to .ogg. Exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            System.err.println("Error during FFmpeg conversion: " + e.getMessage());
        }
        return outputFile;
    }

    private String findFFmpeg() {
        File minecraftDir = class_310.method_1551().field_1697;
        File ffmpegExe = new File(minecraftDir, "ffmpeg.exe");
        if (ffmpegExe.exists()) {
            return ffmpegExe.getAbsolutePath();
        }
        File ffmpegFolder = new File(minecraftDir, "ffmpeg");
        if (ffmpegFolder.exists() && (ffmpegExe = new File(ffmpegFolder, "ffmpeg.exe")).exists()) {
            return ffmpegExe.getAbsolutePath();
        }
        return "ffmpeg";
    }

    private void printProcessOutput(Process process) {
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading FFmpeg output: " + e.getMessage());
            }
        }).start();
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.err.println(line);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading FFmpeg error stream: " + e.getMessage());
            }
        }).start();
    }

    private void enableResourcePackInOptions() {
        File optionsFile = new File(class_310.method_1551().field_1697, "options.txt");
        if (!optionsFile.exists()) {
            return;
        }
        try {
            List<String> lines = Files.readAllLines(optionsFile.toPath());
            for (int i = 0; i < lines.size(); ++i) {
                int insertAt;
                String line = lines.get(i);
                if (!line.startsWith("resourcePacks:")) continue;
                if (!line.contains("file/autogenerated_custom_music") && (insertAt = line.lastIndexOf("]")) > 0) {
                    String before;
                    String updated = before + ((before = line.substring(0, insertAt)).endsWith("[") ? "" : ",") + "\"file/autogenerated_custom_music\"]";
                    lines.set(i, updated);
                    Files.write(optionsFile.toPath(), lines, new OpenOption[0]);
                    System.out.println("Enabled autogenerated_custom_music in options.txt");
                }
                return;
            }
            lines.add("resourcePacks:[\"file/autogenerated_custom_music\"]");
            Files.write(optionsFile.toPath(), lines, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to modify options.txt: " + e.getMessage());
        }
    }

    private void deleteFolder(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    private int playSoundCommand(CommandContext<FabricClientCommandSource> context, String soundId, float pitch, float volume, boolean loop) {
        class_310 client = class_310.method_1551();
        if (client.method_1483() != null) {
            client.method_1483().method_4881();
        }
        if (this.isLooping) {
            this.isLooping = false;
        }
        this.playSound(soundId, pitch, volume);
        if (loop) {
            this.isLooping = true;
            this.loopingSoundId = soundId;
            this.loopingPitch = pitch;
            this.loopingVolume = volume;
            this.startLoopChecker();
        }
        this.sendMsg(context, "\u00a7aPlaying sound: " + soundId + " at pitch " + pitch + ", volume " + volume + (loop ? " (looping)" : ""));
        return 1;
    }

    private void playSound(String soundIdString, float pitch, float volume) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_2960 id = class_2960.method_12829((String)soundIdString);
        if (id == null || !client.method_1483().method_4864().contains(id)) {
            return;
        }
        class_3414 soundEvent = class_3414.method_47908((class_2960)id);
        class_1109 soundInstance = class_1109.method_4757((class_3414)soundEvent, (float)pitch, (float)volume);
        this.currentLoopingInstance = soundInstance;
        client.method_1483().method_4873((class_1113)soundInstance);
    }

    private void startLoopChecker() {
        this.scheduler.scheduleAtFixedRate(() -> {
            boolean isPlaying;
            class_310 client = class_310.method_1551();
            if (client.method_1483() != null && this.currentLoopingInstance != null && !(isPlaying = client.method_1483().method_4877(this.currentLoopingInstance)) && this.isLooping) {
                this.playSound(this.loopingSoundId, this.loopingPitch, this.loopingVolume);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private float parseFloat(String str, float defaultValue) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    private void sendMsg(CommandContext<FabricClientCommandSource> context, String message) {
        ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353(class_2561.method_30163((String)message), false);
    }

    private void sendMsgToPlayer(String message) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353(class_2561.method_30163((String)message), false);
        }
    }
}

