package com.kssjw.kineticminecart.mount;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1695;
import net.minecraft.class_238;
import net.minecraft.class_3218;

public final class MinecartAutoMount {
    // 配置项
    private static final double CHECK_RADIUS = 0.76468; // 单位：blocks 自己测量的哦，比较精确了
    private static final int COOLDOWN_TICKS = 10; // 可选：触发后短暂冷却，避免重复（0 不启用）

    // 简单内存：记录最近触发时间（可根据需要换成 WeakHashMap）
    private static final java.util.Map<class_1688, Integer> cooldownMap = new java.util.WeakHashMap<>();

    // 主入口：在每个矿车 tick 或全局 tick 调用
    public static void maybeAutoMount(class_1688 minecart) {

        // 只允许普通矿车触发，排除运输矿车这些杂鱼
        if (!(minecart instanceof class_1695)) return;

        // 仅服务器端
        if (minecart.method_73183().method_8608()) return;
        if (!(minecart.method_73183() instanceof class_3218)) return;

        // 已有乘客则不触发
        if (!minecart.method_5685().isEmpty()) return;

        // 冷却检查（可选）
        if (COOLDOWN_TICKS > 0) {
            Integer ticksLeft = cooldownMap.get(minecart);
            if (ticksLeft != null && ticksLeft > 0) {
                cooldownMap.put(minecart, ticksLeft - 1);
                return;
            }
        }

        // 检测范围内的实体
        class_238 box = minecart.method_5829().method_1014(CHECK_RADIUS);
        List<class_1297> nearby = minecart.method_73183().method_8333(minecart, box, canAutoMountFilter(minecart));

        for (class_1297 e : nearby) {
            // 再次确认：目标没有已在骑乘、并且能被骑
            if (e.method_5765() || e.method_5782()) continue;

            // 强制上车（服务器端调用）
            boolean mounted = e.method_5804(minecart);
            if (mounted) {
                if (COOLDOWN_TICKS > 0) cooldownMap.put(minecart, COOLDOWN_TICKS);
                break; // 一个实体上车就够了
            }
        }
    }

    // 白名单过滤：只针对想要自动上车的实体类型
    private static Predicate<class_1297> canAutoMountFilter(class_1688 minecart) {
        return entity -> {
            // 排除客户端、非生物实体或已经在骑乘/被骑的实体
            if (entity.method_73183().method_8608()) return false;
            if (entity.method_5765() || entity.method_5782()) return false;

            // 明确排除掉落物与其他非生物实体
            if (entity instanceof class_1542) return false;

            // 排除玩家
            if (entity instanceof class_1657) return false;

            // 允许所有 LivingEntity（动物、村民、怪物、马等）
            if (entity instanceof class_1309) return true;

            // 其余类型一律不允许
            return false;
        };
    }
}