package com.kssjw.kineticminecart.mount;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1695;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public final class MinecartAutoMount {

    // 主入口：在每个矿车 tick 或全局 tick 调用
    public static void maybeAutoMount(class_1688 minecart) {

        // 仅服务器端
        if (minecart.method_5770().method_8608()) return;
        if (!(minecart.method_5770() instanceof class_3218)) return;

        // 排除情况
        if (
            !(minecart instanceof class_1695) // 只允许普通矿车触发，排除运输矿车这些杂鱼
            || !minecart.method_5685().isEmpty()  // 已有乘客则不触发
        ) return;

        // 原版未激活的动力铁轨上的矿车不能吸引生物
        class_2338 pos = minecart.method_24515();
        class_2680 state = minecart.method_5770().method_8320(pos);
        if (state.method_26204() instanceof class_2442 && !state.method_11654(class_2442.field_11364)) return;
        
        // 检测范围内的实体
        class_238 box = minecart.method_5829();
        List<class_1297> nearby = minecart.method_5770().method_8333(minecart, box, canAutoMountFilter(minecart));

        for (class_1297 e : nearby) {

            // 再次确认：目标没有已在骑乘、并且能被骑
            if (e.method_5765() || e.method_5782()) continue;

            // 强制上车（服务器端调用）
            boolean mounted = e.method_5804(minecart);
            if (mounted) break; // 一个实体上车就够了
        }
    }

    // 白名单过滤：只针对想要自动上车的实体类型
    private static Predicate<class_1297> canAutoMountFilter(class_1688 minecart) {
        return entity -> {

            // 排除情况
            if (entity.method_5770().method_8608()   // 排除客户端
                || entity.method_5765() // 排除已经在骑乘
                || entity.method_5782()   // 排除被骑
                || entity instanceof class_1542 // 排除掉落物与其他非生物实体
                || entity instanceof class_1657 // 排除玩家
            ) return false;

            // 允许所有 LivingEntity（动物、村民、怪物、马等）
            if (entity instanceof class_1309) return true;

            // 其余类型一律不允许
            return false;
        };
    }
}