package com.kssjw.kineticminecart.util;

import net.minecraft.class_1297;
import net.minecraft.class_243;

public final class EntityUtils {

    public static boolean isValidTarget(class_1297 entity) {
        return entity.method_5805();
    }

    /**
     * 对实体施加一次速度推力（非直接伤害），在现代映射中使用 setDeltaMovement 替代已移除的 velocityModified / addVelocity。
     *
     * @param entity    目标实体
     * @param direction 单位方向向量（不必规范化，方法内部会按 strength 缩放）
     * @param strength  强度系数
     */
    public static void knockBack(class_1297 entity, class_243 direction, double strength) {
        if (entity == null) return;

        // 计算附加速度（direction 乘以强度）
        class_243 add = direction.method_1021(strength);

        // 获取当前速度并累加
        class_243 current = entity.method_18798();
        class_243 next = current.method_1019(add);

        // 应用新的速度
        entity.method_18799(next);

        // 在部分映射/版本中，你可能希望标记实体已被外力影响以便同步表现
        // 如果需要，可在这里对特定实体类型触发额外逻辑（例如对 LivingEntity 调用 knockback 效果）
    }

    private EntityUtils() {}
}