package com.kssjw.kineticminecart.damage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import com.kssjw.kineticminecart.util.SpeedJudge;

public class MinecartImpactHandler {

    private MinecartImpactHandler() {}

    // lastHitTicks 存储 entityId -> lastHitGameTime（server tick time）
    private static final Map<Integer, Long> lastHitTicks = new ConcurrentHashMap<>();

    // 忽略某些过时方法的警告
    @SuppressWarnings("deprecation")

    // 仅在服务端执行
    public static void tryApplyImpact(class_1688 minecart, class_1297 target) {

        if (minecart == null || target == null) return;

        class_1937 level = minecart.method_73183();
        if (level == null || level.method_8608()) return; // 仅在服务端执行
               
        // 强转 ServerLevel 以获取 DamageSource 工厂（DamageSources 工具类）
        if (!(level instanceof class_3218 serverLevel)) return;

        // 冷却检查
        long now = level.method_8510();
        int tid = target.method_5628();
        Long last = lastHitTicks.get(tid);
        if (last != null && (now - last) < SpeedJudge.COOLDOWN_TICKS) return;
        lastHitTicks.put(tid, now);

        // 排除情况
        if (
            target instanceof class_1688  // 避免矿车被"撞死"，哈哈哈矿车也是生物(
            || target instanceof class_1542 // 避免掉落物被"撞死"
            || (target.method_5765() && target.method_5854() instanceof class_1688)    // 坐在矿车上的乘客不被撞死
        ) return;

        // 计算伤害
        float damage;
        if (SpeedJudge.catchedSpeed >= 6) {
            damage = (float)Math.pow(SpeedJudge.catchedSpeed, 3);
        } else if (SpeedJudge.catchedSpeed < 6 && SpeedJudge.catchedSpeed > 2) {
            damage = (float)Math.pow(SpeedJudge.catchedSpeed, 2);
        } else return;

        // 处刑
        class_1282 src = DamageSources.generic(serverLevel);  
        target.method_64419(src, damage);   // 对实体造成伤害，该方法虽然可能过时，但是能用就行（

        // Testing Logger
        // Logger.printDamage(damage);
    }
}