package com.kssjw.kineticminecart.mixin;

import com.kssjw.kineticminecart.damage.MinecartImpactHandler;
import com.kssjw.kineticminecart.knock.MinecartKonckHandler;
import com.kssjw.kineticminecart.util.SpeedJudge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_238;

@Mixin(class_1688.class)
public abstract class AbstractMinecartMixin {

    @Inject(method = "tick", at = @At("TAIL"))
    private void onTick(CallbackInfo ci) {
        class_1688 self = (class_1688) (Object) this;

        class_1937 level = self.method_73183(); 
        if (level == null || level.method_8608()) return; // 仅服务端处理

        SpeedJudge.catchedSpeed = SpeedJudge.getSpeed(self);

        // Testing Logger
        // Logger.printSpeed(SpeedJudge.catchedSpeed);

        // 若矿车速度不足则跳过,避免频繁查询实体，最后触发生物上车
        if (SpeedJudge.catchedSpeed > 2) {

            // 检测范围
            double radius = 0.5;
            class_238 box = self.method_5829().method_1014(radius);

            // 获取附近实体并过滤一些不需要的类型（自身、已死、不可交互等）
            List<class_1297> list = level.method_8333(self, box, e -> e != self && e.method_5805());
            if (list.isEmpty()) return;

            for (class_1297 target : list) {

                // 对每个目标调用 handler（handler 内部处理冷却/服务端校验）
                MinecartImpactHandler.tryApplyImpact(self, target);
                MinecartKonckHandler.tryApplyKonck(self, target);
            }
        } // else MinecartAutoMount.maybeAutoMount(self);   // 备用，如果生物无法自动乘坐矿车则启用
    }
}