package com.kssjw.kineticminecart.damage;

import com.kssjw.kineticminecart.mount.MinecartAutoMount;
import com.kssjw.kineticminecart.util.EntityUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class MinecartImpactHandler {

    // 可调参数，伤害值与击退强度被移用到后面
    public static double MIN_SPEED_THRESHOLD = 0.2; // 最低速度阈值（平方和阈值会用 lengthSqr 比较）
    public static long COOLDOWN_TICKS = 10L;        // 每实体冷却时间（tick），避免每 tick 重复伤害

    // lastHitTicks 存储 entityId -> lastHitGameTime（server tick time）
    private static final Map<Integer, Long> lastHitTicks = new ConcurrentHashMap<>();

    private MinecartImpactHandler() {}

    // 尝试对 target 应用矿车撞击效果（伤害 + 击退）
    // 仅在服务端执行
    public static void tryApplyImpact(class_1688 minecart, class_1297 target) {
        if (minecart == null || target == null) return;

        class_1937 level = minecart.method_37908();
        if (level == null || level.method_8608()) return; // 仅在服务端执行

        // 保存矿车原始速度，确保最后恢复
        class_243 originalMv = minecart.method_18798();

        // 速度阈值判断（使用平方以避免开方）
        class_243 mv = originalMv;
        double speedSqr = mv.method_1027();
        if (speedSqr < MIN_SPEED_THRESHOLD * MIN_SPEED_THRESHOLD) return;

        // 避免矿车被"撞死"
        // 哈哈哈矿车也是生物(
        if (target instanceof class_1688) return;

        // 避免掉落物被"撞死"
        if (target instanceof class_1542) return;

        // 冷却检查
        long now = level.method_8510();
        int tid = target.method_5628();
        Long last = lastHitTicks.get(tid);
        if (last != null && (now - last) < COOLDOWN_TICKS) return;
        lastHitTicks.put(tid, now);

        // 强转 ServerLevel 以获取 DamageSource 工厂（DamageSources 工具类）
        if (!(level instanceof class_3218 serverLevel)) return;

        // 计算伤害
        float speed = (float)Math.sqrt(speedSqr);
        float speed_per_sec = speed * 4;
        float damage;
        if (speed_per_sec >= 6) {
            damage = (float)Math.pow(speed_per_sec, 3);
        } else if (speed_per_sec < 6 && speed_per_sec > 2) {
            damage = (float)Math.pow(speed_per_sec, 2);
        } else {

            // 还原生物上车
            MinecartAutoMount.maybeAutoMount(minecart);
            return;
        }
        
        class_1282 src = DamageSources.generic(serverLevel);  

        if (target.method_5765() && target.method_5854() instanceof class_1688) {
            return; // 坐在矿车上的乘客不被撞死
        } else target.method_5643(src, damage);   // 对实体造成伤害
        // 应用击退
        class_243 dir = target.method_19538().method_1020(minecart.method_19538());
        double len = dir.method_1033();
        class_243 knockDir;
        if (len <= 1e-6) {
            class_243 carDir = mv.method_1027() > 1e-6 ? mv.method_1029() : new class_243(0, 0.5, 0);
            knockDir = carDir.method_1029();
        } else {
            knockDir = dir.method_1021(1.0 / len);
        }

        if (speed_per_sec <= 2) {
            return; // 速度过低不击退
        } else EntityUtils.knockBack(target, knockDir, (double)speed_per_sec);  // 第三个参数是击退距离
        
        // 恢复矿车原始速度，确保矿车动量不丢失
        minecart.method_18799(originalMv);
    }
}