/*
 * Decompiled with CFR 0.152.
 */
package com.kssjw.kineticminecart.damage;

import com.kssjw.kineticminecart.damage.DamageSources;
import com.kssjw.kineticminecart.util.SpeedJudge;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class MinecartImpactHandler {
    private static final Map<Integer, Long> lastHitTicks = new ConcurrentHashMap<Integer, Long>();

    private MinecartImpactHandler() {
    }

    public static void tryApplyImpact(class_1688 minecart, class_1297 target) {
        float damage;
        if (minecart == null || target == null) {
            return;
        }
        class_1937 level = minecart.method_37908();
        if (level == null || level.method_8608()) {
            return;
        }
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        long now = level.method_8510();
        int tid = target.method_5628();
        Long last = lastHitTicks.get(tid);
        if (last != null && now - last < SpeedJudge.COOLDOWN_TICKS) {
            return;
        }
        lastHitTicks.put(tid, now);
        if (target instanceof class_1688 || target instanceof class_1542 || target.method_5765() && target.method_5854() instanceof class_1688) {
            return;
        }
        if (SpeedJudge.catchedSpeed >= 6.0f) {
            damage = (float)Math.pow(SpeedJudge.catchedSpeed, 3.0);
        } else if (SpeedJudge.catchedSpeed < 6.0f && SpeedJudge.catchedSpeed > 2.0f) {
            damage = (float)Math.pow(SpeedJudge.catchedSpeed, 2.0);
        } else {
            return;
        }
        class_1282 src = DamageSources.generic(serverLevel);
        target.method_64419(src, damage);
    }
}

