/*
 * Decompiled with CFR 0.152.
 */
package com.kssjw.kineticminecart.damage;

import com.kssjw.kineticminecart.damage.DamageSources;
import com.kssjw.kineticminecart.mount.MinecartAutoMount;
import com.kssjw.kineticminecart.util.EntityUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class MinecartImpactHandler {
    public static double MIN_SPEED_THRESHOLD = 0.2;
    public static long COOLDOWN_TICKS = 10L;
    private static final Map<Integer, Long> lastHitTicks = new ConcurrentHashMap<Integer, Long>();

    private MinecartImpactHandler() {
    }

    public static void tryApplyImpact(class_1688 minecart, class_1297 target) {
        class_243 knockDir;
        float damage;
        if (minecart == null || target == null) {
            return;
        }
        class_1937 level = minecart.method_37908();
        if (level == null || level.method_8608()) {
            return;
        }
        class_243 originalMv = minecart.method_18798();
        class_243 mv = originalMv;
        double speedSqr = mv.method_1027();
        if (speedSqr < MIN_SPEED_THRESHOLD * MIN_SPEED_THRESHOLD) {
            return;
        }
        if (target instanceof class_1688) {
            return;
        }
        if (target instanceof class_1542) {
            return;
        }
        long now = level.method_8510();
        int tid = target.method_5628();
        Long last = lastHitTicks.get(tid);
        if (last != null && now - last < COOLDOWN_TICKS) {
            return;
        }
        lastHitTicks.put(tid, now);
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        float speed = (float)Math.sqrt(speedSqr);
        float speed_per_sec = speed * 4.0f;
        if (speed_per_sec >= 6.0f) {
            damage = (float)Math.pow(speed_per_sec, 3.0);
        } else if (speed_per_sec < 6.0f && speed_per_sec > 2.0f) {
            damage = (float)Math.pow(speed_per_sec, 2.0);
        } else {
            MinecartAutoMount.maybeAutoMount(minecart);
            return;
        }
        class_1282 src = DamageSources.generic(serverLevel);
        if (target.method_5765() && target.method_5854() instanceof class_1688) {
            return;
        }
        target.method_64419(src, damage);
        class_243 dir = target.method_19538().method_1020(minecart.method_19538());
        double len = dir.method_1033();
        if (len <= 1.0E-6) {
            class_243 carDir = mv.method_1027() > 1.0E-6 ? mv.method_1029() : new class_243(0.0, 0.5, 0.0);
            knockDir = carDir.method_1029();
        } else {
            knockDir = dir.method_1021(1.0 / len);
        }
        if (speed_per_sec <= 2.0f) {
            return;
        }
        EntityUtils.knockBack(target, knockDir, speed_per_sec);
        minecart.method_18799(originalMv);
    }
}

