/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.meatminer.content;

import com.github.stellarwind22.meatminer.object.MeatBlock;
import com.github.stellarwind22.meatminer.object.MeatPane;
import com.github.stellarwind22.meatminer.object.MeatSlab;
import com.github.stellarwind22.meatminer.object.MeatStairs;
import com.github.stellarwind22.meatminer.util.MBlock;
import com.github.stellarwind22.meatminer.util.MBlockProps;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class MeatMinerBlocks {
    private static DeferredRegister<Block> BLOCKS;
    public static final MBlockProps MEAT_PROPS;
    public static final MBlockProps COOKED_MEAT_PROPS;
    public static RegistrySupplier<Block> MEAT_BLOCK;
    public static RegistrySupplier<Block> MEAT_STAIRS;
    public static RegistrySupplier<Block> MEAT_SLAB;
    public static RegistrySupplier<Block> COBBLEMEAT_BLOCK;
    public static RegistrySupplier<Block> COBBLEMEAT_STAIRS;
    public static RegistrySupplier<Block> COBBLEMEAT_SLAB;
    public static RegistrySupplier<Block> MEMBRANE;
    public static RegistrySupplier<Block> MEAT_ORE;
    public static RegistrySupplier<Block> DEEPSLATE_MEAT_ORE;
    public static RegistrySupplier<Block> NETHERRACK_MEAT_ORE;
    public static RegistrySupplier<Block> END_STONE_MEAT_ORE;
    public static RegistrySupplier<Block> COOKED_MEAT_BLOCK;
    public static RegistrySupplier<Block> COOKED_MEAT_STAIRS;
    public static RegistrySupplier<Block> COOKED_MEAT_SLAB;
    public static RegistrySupplier<Block> COOKED_COBBLEMEAT_BLOCK;
    public static RegistrySupplier<Block> COOKED_COBBLEMEAT_STAIRS;
    public static RegistrySupplier<Block> COOKED_COBBLEMEAT_SLAB;
    public static RegistrySupplier<Block> COOKED_MEMBRANE;
    public static RegistrySupplier<Block> COOKED_MEAT_ORE;
    public static RegistrySupplier<Block> DEEPSLATE_COOKED_MEAT_ORE;
    public static RegistrySupplier<Block> NETHERRACK_COOKED_MEAT_ORE;
    public static RegistrySupplier<Block> END_STONE_COOKED_MEAT_ORE;

    public static void init() {
        BLOCKS = DeferredRegister.create((String)"meatminer", (ResourceKey)Registries.BLOCK);
        MEAT_BLOCK = MeatMinerBlocks.registerBlock("meat_block", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, Optional.of(COOKED_MEAT_BLOCK)), Optional.of(MEAT_PROPS.getCopy())));
        MEAT_STAIRS = MeatMinerBlocks.registerBlock("meat_stairs", new MBlock(props -> new MeatStairs(Blocks.STONE.defaultBlockState(), (BlockBehaviour.Properties)props, Optional.of(COOKED_MEAT_STAIRS)), Optional.of(MEAT_PROPS.getCopy())));
        MEAT_SLAB = MeatMinerBlocks.registerBlock("meat_slab", new MBlock(props -> new MeatSlab((BlockBehaviour.Properties)props, Optional.of(COOKED_MEAT_SLAB)), Optional.of(MEAT_PROPS.getCopy())));
        COBBLEMEAT_BLOCK = MeatMinerBlocks.registerBlock("cobblemeat", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, Optional.of(COOKED_COBBLEMEAT_BLOCK)), Optional.of(MEAT_PROPS.getCopy())));
        COBBLEMEAT_STAIRS = MeatMinerBlocks.registerBlock("cobblemeat_stairs", new MBlock(props -> new MeatStairs(Blocks.STONE.defaultBlockState(), (BlockBehaviour.Properties)props, Optional.of(COOKED_COBBLEMEAT_STAIRS)), Optional.of(MEAT_PROPS.getCopy())));
        COBBLEMEAT_SLAB = MeatMinerBlocks.registerBlock("cobblemeat_slab", new MBlock(props -> new MeatSlab((BlockBehaviour.Properties)props, Optional.of(COOKED_COBBLEMEAT_SLAB)), Optional.of(MEAT_PROPS.getCopy())));
        MEMBRANE = MeatMinerBlocks.registerBlock("membrane", new MBlock(props -> new MeatPane((BlockBehaviour.Properties)props, Optional.of(COOKED_MEMBRANE)), Optional.of(MEAT_PROPS.getCopy())));
        MEAT_ORE = MeatMinerBlocks.registerBlock("meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false, Optional.of(COOKED_MEAT_ORE)), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
        DEEPSLATE_MEAT_ORE = MeatMinerBlocks.registerBlock("deepslate_meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false, Optional.of(DEEPSLATE_COOKED_MEAT_ORE)), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE))));
        NETHERRACK_MEAT_ORE = MeatMinerBlocks.registerBlock("netherrack_meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false, Optional.of(NETHERRACK_COOKED_MEAT_ORE)), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERRACK))));
        END_STONE_MEAT_ORE = MeatMinerBlocks.registerBlock("end_stone_meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false, Optional.of(END_STONE_COOKED_MEAT_ORE)), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE))));
        COOKED_MEAT_BLOCK = MeatMinerBlocks.registerBlock("cooked_meat_block", new MBlock(MeatBlock::new, Optional.of(COOKED_MEAT_PROPS.getCopy())));
        COOKED_MEAT_STAIRS = MeatMinerBlocks.registerBlock("cooked_meat_stairs", new MBlock(props -> new MeatStairs(((Block)COOKED_MEAT_BLOCK.get()).defaultBlockState(), (BlockBehaviour.Properties)props), Optional.of(COOKED_MEAT_PROPS.getCopy())));
        COOKED_MEAT_SLAB = MeatMinerBlocks.registerBlock("cooked_meat_slab", new MBlock(MeatSlab::new, Optional.of(COOKED_MEAT_PROPS.getCopy())));
        COOKED_COBBLEMEAT_BLOCK = MeatMinerBlocks.registerBlock("cooked_cobblemeat", new MBlock(MeatBlock::new, Optional.of(COOKED_MEAT_PROPS.getCopy())));
        COOKED_COBBLEMEAT_STAIRS = MeatMinerBlocks.registerBlock("cooked_cobblemeat_stairs", new MBlock(props -> new MeatStairs(Blocks.STONE.defaultBlockState(), (BlockBehaviour.Properties)props), Optional.of(COOKED_MEAT_PROPS.getCopy())));
        COOKED_COBBLEMEAT_SLAB = MeatMinerBlocks.registerBlock("cooked_cobblemeat_slab", new MBlock(MeatSlab::new, Optional.of(COOKED_MEAT_PROPS.getCopy())));
        COOKED_MEMBRANE = MeatMinerBlocks.registerBlock("cooked_membrane", new MBlock(MeatPane::new, Optional.of(COOKED_MEAT_PROPS.getCopy())));
        COOKED_MEAT_ORE = MeatMinerBlocks.registerBlock("cooked_meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
        DEEPSLATE_COOKED_MEAT_ORE = MeatMinerBlocks.registerBlock("deepslate_cooked_meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE))));
        NETHERRACK_COOKED_MEAT_ORE = MeatMinerBlocks.registerBlock("netherrack_cooked_meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERRACK))));
        END_STONE_COOKED_MEAT_ORE = MeatMinerBlocks.registerBlock("end_stone_cooked_meat_ore", new MBlock(props -> new MeatBlock((BlockBehaviour.Properties)props, false), Optional.of(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE))));
        BLOCKS.register();
    }

    private static RegistrySupplier<Block> registerBlock(String name, MBlock mBlock) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"meatminer", (String)name));
        if (mBlock.feedInProps().isPresent()) {
            return BLOCKS.register(name, () -> mBlock.blockConstructor().apply(mBlock.feedInProps().orElseThrow().setId(key)));
        }
        return BLOCKS.register(name, () -> mBlock.blockConstructor().apply(BlockBehaviour.Properties.of().setId(key)));
    }

    static {
        MEAT_PROPS = new MBlockProps().strength(0.5f).isValidSpawn(MBlockProps::always).mapColor(MapColor.TERRACOTTA_RED).sound(SoundType.MUD);
        COOKED_MEAT_PROPS = new MBlockProps().strength(0.5f).isValidSpawn(MBlockProps::always).mapColor(MapColor.TERRACOTTA_BROWN).sound(SoundType.MUD);
    }
}

