/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.meatminer.mixin;

import com.github.stellarwind22.meatminer.object.MeatLike;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FlowingFluid.class})
public class FlowingFluidMixin {
    @Inject(at={@At(value="TAIL")}, method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/FluidState;)V"})
    public void tick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, FluidState fluidState, CallbackInfo ci) {
        FlowingFluid self = (FlowingFluid)this;
        if (self.is(FluidTags.LAVA)) {
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(1, 1, 1), (BlockPos)blockPos.offset(-1, -1, -1))) {
                this.meatminer$handleMeat(serverLevel, pos);
            }
        }
    }

    @Unique
    private void meatminer$handleMeat(ServerLevel serverLevel, BlockPos pos) {
        MeatLike meatLike;
        BlockState blockState = serverLevel.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof MeatLike && (meatLike = (MeatLike)block).isRaw()) {
            serverLevel.setBlockAndUpdate(pos, ((Block)meatLike.cookedVersion().get().get()).withPropertiesOf(blockState));
            serverLevel.levelEvent(1501, pos, 0);
        }
    }
}

