/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.meatminer.mixin;

import com.github.stellarwind22.meatminer.config.MeatMinerConfig;
import com.github.stellarwind22.meatminer.content.MeatMinerItems;
import com.github.stellarwind22.meatminer.util.DeferredItem;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MerchantOffer.class})
public abstract class MerchantOfferMixin {
    @Final
    @Shadow
    private ItemCost baseCostA;
    @Final
    @Shadow
    private Optional<ItemCost> costB;

    @Inject(at={@At(value="RETURN")}, method={"getBaseCostA()Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    public void getBaseCostA(CallbackInfoReturnable<ItemStack> cir) {
        if (MeatMinerConfig.modify_trades) {
            ItemStack stack = (ItemStack)cir.getReturnValue();
            int count = stack.getCount();
            if (stack.is(Items.EMERALD)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<Item>(MeatMinerItems.MEAT), count * MeatMinerConfig.emerald_conversion_rate));
            }
            if (stack.is(Items.EMERALD_BLOCK)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<BlockItem>(MeatMinerItems.MEAT_BLOCK), count * 9 * MeatMinerConfig.emerald_conversion_rate / 4));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getCostA()Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    public void getCostA(CallbackInfoReturnable<ItemStack> cir) {
        if (MeatMinerConfig.modify_trades) {
            ItemStack stack = (ItemStack)cir.getReturnValue();
            int count = stack.getCount();
            if (stack.is(Items.EMERALD)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<Item>(MeatMinerItems.MEAT), count * MeatMinerConfig.emerald_conversion_rate));
            }
            if (stack.is(Items.EMERALD_BLOCK)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<BlockItem>(MeatMinerItems.MEAT_BLOCK), count * 9 * MeatMinerConfig.emerald_conversion_rate / 4));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getCostB()Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    public void getCostB(CallbackInfoReturnable<ItemStack> cir) {
        if (MeatMinerConfig.modify_trades) {
            ItemStack stack = (ItemStack)cir.getReturnValue();
            int count = stack.getCount();
            if (stack.is(Items.EMERALD)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<Item>(MeatMinerItems.MEAT), count * MeatMinerConfig.emerald_conversion_rate));
            }
            if (stack.is(Items.EMERALD_BLOCK)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<BlockItem>(MeatMinerItems.MEAT_BLOCK), count * 9 * MeatMinerConfig.emerald_conversion_rate / 4));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getItemCostA()Lnet/minecraft/world/item/trading/ItemCost;"}, cancellable=true)
    public void getItemCostA(CallbackInfoReturnable<ItemCost> cir) {
        ItemCost cost = (ItemCost)cir.getReturnValue();
        int count = cost.count();
        Item item = (Item)cost.item().value();
        if (item.equals(Items.EMERALD)) {
            cir.setReturnValue((Object)new ItemCost(new DeferredItem<Item>(MeatMinerItems.MEAT), count * MeatMinerConfig.emerald_conversion_rate));
        }
        if (item.equals(Items.EMERALD_BLOCK)) {
            cir.setReturnValue((Object)new ItemCost(new DeferredItem<BlockItem>(MeatMinerItems.MEAT_BLOCK), count * 9 * MeatMinerConfig.emerald_conversion_rate / 4));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getItemCostB()Ljava/util/Optional;"}, cancellable=true)
    public void getItemCostB(CallbackInfoReturnable<Optional<ItemCost>> cir) {
        Optional returnValue = (Optional)cir.getReturnValue();
        if (returnValue.isPresent()) {
            ItemCost cost = (ItemCost)returnValue.get();
            int count = cost.count();
            Item item = (Item)cost.item().value();
            if (item.equals(Items.EMERALD)) {
                cir.setReturnValue(Optional.of(new ItemCost(new DeferredItem<Item>(MeatMinerItems.MEAT), count * MeatMinerConfig.emerald_conversion_rate)));
            }
            if (item.equals(Items.EMERALD_BLOCK)) {
                cir.setReturnValue(Optional.of(new ItemCost(new DeferredItem<BlockItem>(MeatMinerItems.MEAT_BLOCK), count * 9 * MeatMinerConfig.emerald_conversion_rate / 4)));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getResult()Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    public void getResult(CallbackInfoReturnable<ItemStack> cir) {
        if (MeatMinerConfig.modify_trades) {
            ItemStack stack = (ItemStack)cir.getReturnValue();
            int count = stack.getCount();
            if (stack.is(Items.EMERALD)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<Item>(MeatMinerItems.MEAT), count * MeatMinerConfig.emerald_conversion_rate));
            }
            if (stack.is(Items.EMERALD_BLOCK)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<BlockItem>(MeatMinerItems.MEAT_BLOCK), count * 9 * MeatMinerConfig.emerald_conversion_rate / 4));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"assemble()Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    public void assemble(CallbackInfoReturnable<ItemStack> cir) {
        if (MeatMinerConfig.modify_trades) {
            ItemStack stack = (ItemStack)cir.getReturnValue();
            int count = stack.getCount();
            if (stack.is(Items.EMERALD)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<Item>(MeatMinerItems.MEAT), count * MeatMinerConfig.emerald_conversion_rate));
            }
            if (stack.is(Items.EMERALD_BLOCK)) {
                cir.setReturnValue((Object)new ItemStack(new DeferredItem<BlockItem>(MeatMinerItems.MEAT_BLOCK), count * 9 * MeatMinerConfig.emerald_conversion_rate / 4));
            }
        }
    }

    @Shadow
    public abstract ItemCost getItemCostA();

    @Shadow
    public abstract Optional<ItemCost> getItemCostB();

    @Unique
    @WrapOperation(method={"satisfiedBy(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/trading/ItemCost;test(Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean meatminer$satisfiedBy$testWrapper(ItemCost instance, ItemStack itemStack, Operation<Boolean> original) {
        ItemCost cost = instance == this.baseCostA ? this.getItemCostA() : (instance == this.costB.orElse(null) ? this.getItemCostB().orElse(instance) : instance);
        return (Boolean)original.call(new Object[]{cost, itemStack});
    }
}

