/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.meatminer.object;

import com.github.stellarwind22.meatminer.object.MeatLike;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class MeatBlock
extends Block
implements MeatLike {
    private final boolean drips;
    private final Optional<RegistrySupplier<Block>> cookedVersion;

    public MeatBlock(BlockBehaviour.Properties properties, boolean drips, Optional<RegistrySupplier<Block>> cookedVersion) {
        super(properties);
        this.drips = drips;
        this.cookedVersion = cookedVersion;
    }

    public MeatBlock(BlockBehaviour.Properties properties, Optional<RegistrySupplier<Block>> cookedVersion) {
        this(properties, true, cookedVersion);
    }

    public MeatBlock(BlockBehaviour.Properties properties, boolean drips) {
        this(properties, drips, Optional.empty());
    }

    public MeatBlock(BlockBehaviour.Properties properties) {
        this(properties, true, Optional.empty());
    }

    public void onPlace(BlockState newState, Level level, BlockPos blockPos, BlockState oldState, boolean bl) {
        super.onPlace(newState, level, blockPos, oldState, bl);
        this.handleLava(level, blockPos.offset(1, 1, 1));
    }

    public void handleLava(Level level, BlockPos blockPos) {
        FluidState state = level.getFluidState(blockPos);
        if (state.is(FluidTags.LAVA)) {
            level.scheduleTick(blockPos, state.getType(), state.getType().getTickDelay((LevelReader)level));
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        this.dripAnimation(level, blockPos, randomSource);
    }

    @Override
    public boolean drips() {
        return this.drips;
    }

    @Override
    public boolean isRaw() {
        return this.cookedVersion.isPresent();
    }

    @Override
    public Optional<RegistrySupplier<Block>> cookedVersion() {
        return this.cookedVersion;
    }
}

