/*
 * Decompiled with CFR 0.152.
 */
package com.github.stellarwind22.meatminer.util;

import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7696;
import net.minecraft.class_7701;
import org.jetbrains.annotations.Nullable;

public class MBlockProps {
    public Function<class_2680, class_3620> mapColor = blockState -> class_3620.field_16008;
    boolean hasCollision = true;
    public class_2498 soundType = class_2498.field_11544;
    public ToIntFunction<class_2680> lightEmission = blockState -> 0;
    public float explosionResistance = 0.0f;
    public float destroyTime = 0.0f;
    public boolean requiresCorrectToolForDrops;
    public boolean isRandomlyTicking;
    public float friction = 0.6f;
    public float speedFactor = 1.0f;
    public float jumpFactor = 1.0f;
    @Nullable
    public class_5321<class_2248> id;
    public boolean canOcclude = true;
    public boolean isAir;
    public boolean ignitedByLava;
    boolean forceSolidOn;
    public class_3619 pushReaction = class_3619.field_15974;
    boolean spawnTerrainParticles = true;
    public class_2766 instrument = class_2766.field_12648;
    public class_4970.class_4972<class_1299<?>> isValidSpawn = (blockState, blockGetter, blockPos, entityType) -> blockState.method_26206(blockGetter, blockPos, class_2350.field_11036) && blockState.method_26213() < 14;
    public class_4970.class_4973 isRedstoneConductor = class_4970.class_4971::method_26234;
    public class_4970.class_4973 isSuffocating;
    public class_4970.class_4973 isViewBlocking = this.isSuffocating = (blockState, blockGetter, blockPos) -> blockState.method_51366() && blockState.method_26234(blockGetter, blockPos);
    public class_4970.class_4973 hasPostProcess = (blockState, blockGetter, blockPos) -> false;
    public class_4970.class_4973 emissiveRendering = (blockState, blockGetter, blockPos) -> false;
    public boolean dynamicShape;
    public List<class_7696> requiredFeatures = List.of(class_7701.field_40177);

    public class_4970.class_2251 getCopy() {
        class_4970.class_2251 copy = class_4970.class_2251.method_9637();
        copy.method_51520(this.mapColor);
        copy.method_9626(this.soundType);
        copy.method_9631(this.lightEmission);
        copy.method_9628(this.friction);
        copy.method_23351(this.speedFactor);
        copy.method_23352(this.jumpFactor);
        copy.method_50012(this.pushReaction);
        copy.method_51368(this.instrument);
        copy.method_45476(this.requiredFeatures.toArray(new class_7696[0]));
        copy.method_9629(this.destroyTime, this.explosionResistance);
        if (!this.hasCollision) {
            copy.method_9634();
        }
        if (!this.canOcclude) {
            copy.method_22488();
        }
        if (this.forceSolidOn) {
            copy.method_51369();
        }
        if (this.requiresCorrectToolForDrops) {
            copy.method_29292();
        }
        if (this.isRandomlyTicking) {
            copy.method_9640();
        }
        if (this.isAir) {
            copy.method_26250();
        }
        if (this.ignitedByLava) {
            copy.method_50013();
        }
        if (this.dynamicShape) {
            copy.method_9624();
        }
        if (!this.spawnTerrainParticles) {
            copy.method_45477();
        }
        copy.method_26235(this.isValidSpawn);
        copy.method_26236(this.isRedstoneConductor);
        copy.method_26243(this.isSuffocating);
        copy.method_26245(this.isViewBlocking);
        copy.method_26247(this.hasPostProcess);
        copy.method_26249(this.emissiveRendering);
        return copy;
    }

    public static boolean always(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_1299<?> entityType) {
        return true;
    }

    public static boolean always(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return true;
    }

    public static boolean never(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_1299<?> entityType) {
        return false;
    }

    public static boolean never(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return false;
    }

    public MBlockProps mapColor(class_1767 dyeColor) {
        this.mapColor = blockState -> dyeColor.method_7794();
        return this;
    }

    public MBlockProps mapColor(class_3620 mapColor) {
        this.mapColor = blockState -> mapColor;
        return this;
    }

    public MBlockProps mapColor(Function<class_2680, class_3620> function) {
        this.mapColor = function;
        return this;
    }

    public MBlockProps noCollision() {
        this.hasCollision = false;
        this.canOcclude = false;
        return this;
    }

    public MBlockProps noOcclusion() {
        this.canOcclude = false;
        return this;
    }

    public MBlockProps friction(float f) {
        this.friction = f;
        return this;
    }

    public MBlockProps speedFactor(float f) {
        this.speedFactor = f;
        return this;
    }

    public MBlockProps jumpFactor(float f) {
        this.jumpFactor = f;
        return this;
    }

    public MBlockProps sound(class_2498 soundType) {
        this.soundType = soundType;
        return this;
    }

    public MBlockProps lightLevel(ToIntFunction<class_2680> toIntFunction) {
        this.lightEmission = toIntFunction;
        return this;
    }

    public MBlockProps strength(float f, float g) {
        return this.destroyTime(f).explosionResistance(g);
    }

    public MBlockProps instabreak() {
        return this.strength(0.0f);
    }

    public MBlockProps strength(float f) {
        this.strength(f, f);
        return this;
    }

    public MBlockProps randomTicks() {
        this.isRandomlyTicking = true;
        return this;
    }

    public MBlockProps dynamicShape() {
        this.dynamicShape = true;
        return this;
    }

    public MBlockProps ignitedByLava() {
        this.ignitedByLava = true;
        return this;
    }

    public MBlockProps forceSolidOn() {
        this.forceSolidOn = true;
        return this;
    }

    public MBlockProps pushReaction(class_3619 pushReaction) {
        this.pushReaction = pushReaction;
        return this;
    }

    public MBlockProps air() {
        this.isAir = true;
        return this;
    }

    public MBlockProps isValidSpawn(class_4970.class_4972<class_1299<?>> stateArgumentPredicate) {
        this.isValidSpawn = stateArgumentPredicate;
        return this;
    }

    public MBlockProps isRedstoneConductor(class_4970.class_4973 statePredicate) {
        this.isRedstoneConductor = statePredicate;
        return this;
    }

    public MBlockProps isSuffocating(class_4970.class_4973 statePredicate) {
        this.isSuffocating = statePredicate;
        return this;
    }

    public MBlockProps isViewBlocking(class_4970.class_4973 statePredicate) {
        this.isViewBlocking = statePredicate;
        return this;
    }

    public MBlockProps hasPostProcess(class_4970.class_4973 statePredicate) {
        this.hasPostProcess = statePredicate;
        return this;
    }

    public MBlockProps emissiveRendering(class_4970.class_4973 statePredicate) {
        this.emissiveRendering = statePredicate;
        return this;
    }

    public MBlockProps requiresCorrectToolForDrops() {
        this.requiresCorrectToolForDrops = true;
        return this;
    }

    public MBlockProps destroyTime(float f) {
        this.destroyTime = f;
        return this;
    }

    public MBlockProps explosionResistance(float f) {
        this.explosionResistance = Math.max(0.0f, f);
        return this;
    }
}

