/*
 * Decompiled with CFR 0.152.
 */
package at.blaxk.locatorbar;

import at.blaxk.locatorbar.bstats.bukkit.Metrics;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LocatorBar
extends JavaPlugin
implements Listener,
TabCompleter {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private FileConfiguration config;
    private FileConfiguration messages;
    private Map<UUID, Boolean> playerVisibility = new HashMap<UUID, Boolean>();
    private Map<UUID, Boolean> playerReceiving = new HashMap<UUID, Boolean>();
    private Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();
    private Map<UUID, Long> updateNotificationHidden = new HashMap<UUID, Long>();
    private final String MODRINTH_PROJECT_ID = "KF5O4Zzd";
    private String latestVersion = null;
    private boolean updateAvailable = false;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.createMessagesFile();
        this.loadPlayerData();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("locatorbar").setTabCompleter((TabCompleter)this);
        this.setupPlaceholderAPI();
        this.setupMetrics();
        this.checkForUpdates();
        this.getLogger().info("LocatorBar has been enabled successfully!");
    }

    public void onDisable() {
        this.savePlayerData();
        this.getLogger().info("LocatorBar has been disabled!");
    }

    private void checkForUpdates() {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            block4: {
                try {
                    URL url = new URL("https://api.modrinth.com/v2/project/KF5O4Zzd/version");
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("User-Agent", "LocatorBar/" + this.getDescription().getVersion());
                    if (connection.getResponseCode() == 200) {
                        InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                        JsonObject response = JsonParser.parseReader((Reader)reader).getAsJsonArray().get(0).getAsJsonObject();
                        this.latestVersion = response.get("version_number").getAsString();
                        String currentVersion = this.getDescription().getVersion();
                        if (!this.latestVersion.equals(currentVersion)) {
                            this.updateAvailable = true;
                            this.getLogger().info("Update Available!");
                            this.getLogger().info("Current: " + currentVersion);
                            this.getLogger().info("Latest: " + this.latestVersion);
                            this.getLogger().info("Download: https://modrinth.com/plugin/locator-bar");
                        }
                        reader.close();
                    }
                    connection.disconnect();
                }
                catch (Exception e) {
                    if (!this.config.getBoolean("debug", false)) break block4;
                    this.getLogger().warning("Could not check for updates: " + e.getMessage());
                }
            }
        });
    }

    private void setupPlaceholderAPI() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new LocatorBarPlaceholders(this, this).register();
            this.getLogger().info("PlaceholderAPI integration enabled!");
        }
    }

    private void setupMetrics() {
        int pluginId = 26290;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        this.getLogger().info("bStats metrics enabled!");
    }

    private void createMessagesFile() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private void loadPlayerData() {
        File dataFile = new File(this.getDataFolder(), "playerdata.yml");
        if (dataFile.exists()) {
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            for (String uuid : data.getKeys(false)) {
                long hiddenUntil;
                UUID playerUUID = UUID.fromString(uuid);
                this.playerVisibility.put(playerUUID, data.getBoolean(uuid + ".visible", true));
                this.playerReceiving.put(playerUUID, data.getBoolean(uuid + ".receiving", true));
                if (!data.contains(uuid + ".update-hidden-until") || (hiddenUntil = data.getLong(uuid + ".update-hidden-until")) <= System.currentTimeMillis()) continue;
                this.updateNotificationHidden.put(playerUUID, hiddenUntil);
            }
        }
    }

    private void savePlayerData() {
        File dataFile = new File(this.getDataFolder(), "playerdata.yml");
        YamlConfiguration data = new YamlConfiguration();
        for (Map.Entry<UUID, Boolean> entry : this.playerVisibility.entrySet()) {
            long hiddenUntil;
            String uuid = entry.getKey().toString();
            data.set(uuid + ".visible", (Object)entry.getValue());
            data.set(uuid + ".receiving", (Object)this.playerReceiving.getOrDefault(entry.getKey(), true));
            if (!this.updateNotificationHidden.containsKey(entry.getKey()) || (hiddenUntil = this.updateNotificationHidden.get(entry.getKey()).longValue()) <= System.currentTimeMillis()) continue;
            data.set(uuid + ".update-hidden-until", (Object)hiddenUntil);
        }
        try {
            data.save(dataFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Could not save player data: " + e.getMessage());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Long hiddenUntil;
        boolean isFirstJoin;
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        boolean bl = isFirstJoin = !this.playerVisibility.containsKey(uuid);
        if (isFirstJoin) {
            this.playerVisibility.put(uuid, true);
            this.playerReceiving.put(uuid, true);
            if (this.config.getBoolean("show-first-join-message", true)) {
                this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                    player.sendMessage(this.getMessage("first-join-welcome"));
                    player.sendMessage(this.getMessage("first-join-info"));
                }, 20L);
            }
        }
        this.updatePlayerAttributes(player);
        if (player.isOp() && this.updateAvailable && this.config.getBoolean("update-checker", true) && ((hiddenUntil = this.updateNotificationHidden.get(uuid)) == null || hiddenUntil < System.currentTimeMillis())) {
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> this.showUpdateNotification(player), 40L);
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        this.updatePlayerAttributes(player);
    }

    private void showUpdateNotification(Player player) {
        String currentVersion = this.getDescription().getVersion();
        String downloadUrl = "https://modrinth.com/plugin/locator-bar/version/" + (this.latestVersion != null ? this.latestVersion : "latest");
        Component updateMessage = this.getMessage("update-available").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{current}").replacement(currentVersion).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{latest}").replacement(this.latestVersion != null ? this.latestVersion : "unknown").build());
        Component hideButton = this.getMessage("update-hide-button").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{download_url}").replacement(downloadUrl).build()).clickEvent(ClickEvent.runCommand((String)"/locatorbar hideupdate"));
        player.sendMessage(updateMessage);
        player.sendMessage(hideButton);
    }

    private boolean isWorldForceVisible(String worldName) {
        return this.config.getBoolean("world-settings." + worldName + ".force-visible", false);
    }

    private void updatePlayerAttributes(Player player) {
        double transmitRange;
        UUID uuid = player.getUniqueId();
        String worldName = player.getWorld().getName();
        boolean visible = this.playerVisibility.getOrDefault(uuid, true);
        boolean receiving = this.playerReceiving.getOrDefault(uuid, true);
        if (this.isWorldForceVisible(worldName)) {
            visible = true;
            receiving = true;
        }
        double d = transmitRange = visible ? this.config.getDouble("default-transmit-range", 6.0E7) : 0.0;
        double receiveRange = this.config.getBoolean("disable-receive-when-hidden", false) && !visible ? 0.0 : (receiving ? this.config.getDouble("default-receive-range", 6.0E7) : 0.0);
        try {
            if (player.getAttribute(Attribute.WAYPOINT_TRANSMIT_RANGE) != null) {
                player.getAttribute(Attribute.WAYPOINT_TRANSMIT_RANGE).setBaseValue(transmitRange);
            }
            if (player.getAttribute(Attribute.WAYPOINT_RECEIVE_RANGE) != null) {
                player.getAttribute(Attribute.WAYPOINT_RECEIVE_RANGE).setBaseValue(receiveRange);
            }
            if (this.config.getBoolean("debug", false)) {
                this.getLogger().info("Updated attributes for " + player.getName() + " - Transmit: " + transmitRange + ", Receive: " + receiveRange + (this.isWorldForceVisible(worldName) ? " (Force Visible)" : ""));
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Could not set waypoint attributes for " + player.getName() + ": " + e.getMessage());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player) && args.length > 0 && !args[0].equalsIgnoreCase("reload")) {
            sender.sendMessage(this.getMessage("only-players"));
            return true;
        }
        if (command.getName().equalsIgnoreCase("locatorbar")) {
            if (args.length == 0) {
                if (sender instanceof Player) {
                    this.showHelp((Player)sender);
                } else {
                    sender.sendMessage("Usage: /locatorbar reload");
                }
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "toggle": {
                    Player player;
                    if (!(sender instanceof Player) || !this.checkCooldown(player = (Player)sender)) break;
                    if (this.config.getString("control-mode", "combined").equals("combined")) {
                        this.toggleCombined(player);
                    } else {
                        this.toggleVisibility(player);
                    }
                    this.setCooldown(player);
                    break;
                }
                case "receive": {
                    if (!(sender instanceof Player)) break;
                    Player player = (Player)sender;
                    if (this.config.getString("control-mode", "combined").equals("separate")) {
                        if (!this.checkCooldown(player)) break;
                        this.toggleReceiving(player);
                        this.setCooldown(player);
                        break;
                    }
                    player.sendMessage(this.getMessage("command-not-available"));
                    break;
                }
                case "status": {
                    if (!(sender instanceof Player)) break;
                    this.showStatus((Player)sender);
                    break;
                }
                case "player": {
                    if (sender.hasPermission("locatorbar.admin")) {
                        this.handleAdminPlayerCommand(sender, args);
                        break;
                    }
                    sender.sendMessage(this.getMessage("no-permission"));
                    break;
                }
                case "hideupdate": {
                    Player player;
                    if (!(sender instanceof Player) || !(player = (Player)sender).isOp()) break;
                    this.hideUpdateNotification(player);
                    break;
                }
                case "triggerupdatenotif": {
                    Player player;
                    if (!(sender instanceof Player) || !(player = (Player)sender).isOp()) break;
                    this.latestVersion = "1.1";
                    this.updateAvailable = true;
                    this.showUpdateNotification(player);
                    if (!this.config.getBoolean("debug", false)) break;
                    String downloadUrl = "https://modrinth.com/plugin/locator-bar/version/" + this.latestVersion;
                    player.sendMessage(this.miniMessage.deserialize((Object)("<gray>[DEBUG] Download URL: " + downloadUrl)));
                    break;
                }
                case "help": {
                    if (!(sender instanceof Player)) break;
                    this.showHelp((Player)sender);
                    break;
                }
                case "reload": {
                    if (sender.hasPermission("locatorbar.admin")) {
                        this.reloadConfig();
                        this.createMessagesFile();
                        sender.sendMessage(this.getMessage("config-reloaded"));
                        break;
                    }
                    sender.sendMessage(this.getMessage("no-permission"));
                    break;
                }
                default: {
                    if (!(sender instanceof Player)) break;
                    this.showHelp((Player)sender);
                }
            }
        }
        return true;
    }

    private void hideUpdateNotification(Player player) {
        UUID uuid = player.getUniqueId();
        long hideUntil = System.currentTimeMillis() + 86400000L;
        this.updateNotificationHidden.put(uuid, hideUntil);
        player.sendMessage(this.getMessage("update-hidden"));
        this.savePlayerData();
    }

    private void handleAdminPlayerCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(this.getMessage("admin-usage"));
            return;
        }
        String playerName = args[1];
        String action = args[2].toLowerCase();
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage(this.getMessage("player-not-found"));
            return;
        }
        switch (action) {
            case "toggle": {
                if (this.config.getString("control-mode", "combined").equals("combined")) {
                    this.toggleCombinedAdmin(target, sender);
                    break;
                }
                this.toggleVisibilityAdmin(target, sender);
                break;
            }
            case "status": {
                this.showStatusAdmin(target, sender);
                break;
            }
            default: {
                sender.sendMessage(this.getMessage("admin-usage"));
            }
        }
    }

    private boolean checkCooldown(Player player) {
        int cooldownSeconds;
        long cooldownMillis;
        long lastUsed;
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.cooldownMap.containsKey(uuid) && currentTime - (lastUsed = this.cooldownMap.get(uuid).longValue()) < (cooldownMillis = (long)(cooldownSeconds = this.getCooldownForPlayer(player)) * 1000L)) {
            double remainingSeconds = (double)(cooldownMillis - (currentTime - lastUsed)) / 1000.0;
            String formattedTime = String.format("%.2f", remainingSeconds);
            player.sendMessage(this.getMessage("cooldown-active").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{time}").replacement(formattedTime).build()));
            return false;
        }
        return true;
    }

    private void setCooldown(Player player) {
        this.cooldownMap.put(player.getUniqueId(), System.currentTimeMillis());
    }

    private int getCooldownForPlayer(Player player) {
        if (player.hasPermission("locatorbar.cooldown.bypass")) {
            return 0;
        }
        for (int i = 0; i <= 300; ++i) {
            if (!player.hasPermission("locatorbar.cooldown." + i)) continue;
            return i;
        }
        return this.config.getInt("default-cooldown", 5);
    }

    private void playSound(Player player, String soundType) {
        block6: {
            if (!this.config.getBoolean("sounds.enabled", true)) {
                return;
            }
            String soundName = this.config.getString("sounds." + soundType, "");
            if (soundName.isEmpty()) {
                return;
            }
            try {
                String raw = this.config.getString("sounds.name", "entity.player.levelup");
                String keyString = raw.startsWith("minecraft:") ? raw : "minecraft:" + raw.toLowerCase();
                NamespacedKey key = NamespacedKey.fromString((String)keyString);
                if (key == null) {
                    Bukkit.getLogger().warning("Ung\u00fcltiger Sound-Key: " + raw);
                    return;
                }
                Sound sound = (Sound)Registry.SOUNDS.get(key);
                if (sound == null) {
                    Bukkit.getLogger().warning("Sound nicht im Registry gefunden: " + keyString);
                    return;
                }
                float volume = (float)this.config.getDouble("sounds.volume", 1.0);
                float pitch = (float)this.config.getDouble("sounds.pitch", 1.0);
                player.playSound(player.getLocation(), sound, SoundCategory.MASTER, volume, pitch);
            }
            catch (Exception e) {
                if (!this.config.getBoolean("debug", false)) break block6;
                this.getLogger().warning("Invalid sound: " + soundName + " - " + e.getMessage());
            }
        }
    }

    private void toggleCombined(Player player) {
        UUID uuid = player.getUniqueId();
        String worldName = player.getWorld().getName();
        if (this.isWorldForceVisible(worldName)) {
            player.sendMessage(this.getMessage("world-force-visible"));
            return;
        }
        boolean currentState = this.playerVisibility.getOrDefault(uuid, true);
        boolean newState = !currentState;
        this.playerVisibility.put(uuid, newState);
        if (this.config.getBoolean("disable-receive-when-hidden", false)) {
            this.playerReceiving.put(uuid, newState);
        } else {
            this.playerReceiving.put(uuid, newState);
        }
        this.updatePlayerAttributes(player);
        String messageKey = newState ? "visibility-enabled-combined" : "visibility-disabled-combined";
        player.sendMessage(this.getMessage(messageKey));
        String soundType = newState ? "enable" : "disable";
        this.playSound(player, soundType);
    }

    private void toggleCombinedAdmin(Player target, CommandSender admin) {
        UUID uuid = target.getUniqueId();
        String worldName = target.getWorld().getName();
        if (this.isWorldForceVisible(worldName)) {
            admin.sendMessage(this.getMessage("admin-world-force-visible").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{player}").replacement(target.getName()).build()));
            return;
        }
        boolean currentState = this.playerVisibility.getOrDefault(uuid, true);
        boolean newState = !currentState;
        this.playerVisibility.put(uuid, newState);
        if (this.config.getBoolean("disable-receive-when-hidden", false)) {
            this.playerReceiving.put(uuid, newState);
        } else {
            this.playerReceiving.put(uuid, newState);
        }
        this.updatePlayerAttributes(target);
        String messageKey = newState ? "admin-visibility-enabled" : "admin-visibility-disabled";
        admin.sendMessage(this.getMessage(messageKey).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{player}").replacement(target.getName()).build()));
        String targetMessageKey = newState ? "visibility-enabled-combined" : "visibility-disabled-combined";
        target.sendMessage(this.getMessage(targetMessageKey));
        String soundType = newState ? "enable" : "disable";
        this.playSound(target, soundType);
    }

    private void toggleVisibility(Player player) {
        UUID uuid = player.getUniqueId();
        String worldName = player.getWorld().getName();
        if (this.isWorldForceVisible(worldName)) {
            player.sendMessage(this.getMessage("world-force-visible"));
            return;
        }
        boolean currentState = this.playerVisibility.getOrDefault(uuid, true);
        boolean newState = !currentState;
        this.playerVisibility.put(uuid, newState);
        this.updatePlayerAttributes(player);
        String messageKey = newState ? "visibility-enabled" : "visibility-disabled";
        player.sendMessage(this.getMessage(messageKey));
        String soundType = newState ? "enable" : "disable";
        this.playSound(player, soundType);
    }

    private void toggleVisibilityAdmin(Player target, CommandSender admin) {
        UUID uuid = target.getUniqueId();
        String worldName = target.getWorld().getName();
        if (this.isWorldForceVisible(worldName)) {
            admin.sendMessage(this.getMessage("admin-world-force-visible").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{player}").replacement(target.getName()).build()));
            return;
        }
        boolean currentState = this.playerVisibility.getOrDefault(uuid, true);
        boolean newState = !currentState;
        this.playerVisibility.put(uuid, newState);
        this.updatePlayerAttributes(target);
        String messageKey = newState ? "admin-visibility-enabled" : "admin-visibility-disabled";
        admin.sendMessage(this.getMessage(messageKey).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{player}").replacement(target.getName()).build()));
        String targetMessageKey = newState ? "visibility-enabled" : "visibility-disabled";
        target.sendMessage(this.getMessage(targetMessageKey));
        String soundType = newState ? "enable" : "disable";
        this.playSound(target, soundType);
    }

    private void toggleReceiving(Player player) {
        UUID uuid = player.getUniqueId();
        boolean currentState = this.playerReceiving.getOrDefault(uuid, true);
        boolean newState = !currentState;
        this.playerReceiving.put(uuid, newState);
        this.updatePlayerAttributes(player);
        String messageKey = newState ? "receiving-enabled" : "receiving-disabled";
        player.sendMessage(this.getMessage(messageKey));
        String soundType = newState ? "enable" : "disable";
        this.playSound(player, soundType);
    }

    private void showStatus(Player player) {
        UUID uuid = player.getUniqueId();
        String worldName = player.getWorld().getName();
        boolean visible = this.playerVisibility.getOrDefault(uuid, true);
        boolean receiving = this.playerReceiving.getOrDefault(uuid, true);
        Component visibilityStatus = visible ? this.getMessage("status-visible") : this.getMessage("status-hidden");
        Component receivingStatus = receiving ? this.getMessage("status-receiving") : this.getMessage("status-not-receiving");
        player.sendMessage(this.getMessage("status-header"));
        player.sendMessage(visibilityStatus);
        if (this.config.getString("control-mode", "combined").equals("separate")) {
            player.sendMessage(receivingStatus);
        } else {
            player.sendMessage(this.getMessage("status-combined"));
        }
        if (this.isWorldForceVisible(worldName)) {
            player.sendMessage(this.getMessage("status-world-force"));
        }
    }

    private void showStatusAdmin(Player target, CommandSender admin) {
        UUID uuid = target.getUniqueId();
        String worldName = target.getWorld().getName();
        boolean visible = this.playerVisibility.getOrDefault(uuid, true);
        boolean receiving = this.playerReceiving.getOrDefault(uuid, true);
        admin.sendMessage(this.getMessage("admin-status-header").replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{player}").replacement(target.getName()).build()));
        String visibilityKey = visible ? "admin-status-visible" : "admin-status-hidden";
        String receivingKey = receiving ? "admin-status-receiving" : "admin-status-not-receiving";
        admin.sendMessage(this.getMessage(visibilityKey));
        admin.sendMessage(this.getMessage(receivingKey));
        if (this.isWorldForceVisible(worldName)) {
            admin.sendMessage(this.getMessage("admin-status-world-force"));
        }
    }

    private void showHelp(Player player) {
        String controlMode = this.config.getString("control-mode", "combined");
        if (controlMode.equals("combined")) {
            player.sendMessage(this.getMessage("help-header-combined"));
            player.sendMessage(this.getMessage("help-toggle-combined"));
            player.sendMessage(this.getMessage("help-status-combined"));
            player.sendMessage(this.getMessage("help-help-combined"));
            if (player.hasPermission("locatorbar.admin")) {
                player.sendMessage(this.getMessage("help-player-combined"));
                player.sendMessage(this.getMessage("help-reload-combined"));
            }
        } else {
            player.sendMessage(this.getMessage("help-header"));
            player.sendMessage(this.getMessage("help-toggle"));
            player.sendMessage(this.getMessage("help-receive"));
            player.sendMessage(this.getMessage("help-status"));
            player.sendMessage(this.getMessage("help-help"));
            if (player.hasPermission("locatorbar.admin")) {
                player.sendMessage(this.getMessage("help-player"));
                player.sendMessage(this.getMessage("help-reload"));
            }
        }
    }

    private Component getMessage(String key) {
        String locale = this.config.getString("language", "en");
        String messageKey = locale + "." + key;
        if (!this.messages.contains(messageKey)) {
            messageKey = "en." + key;
        }
        String message = this.messages.getString(messageKey, "<red>Message not found: " + key);
        String prefix = this.messages.getString(locale + ".prefix", this.messages.getString("en.prefix", ""));
        message = message.replace("<prefix>", prefix);
        return this.miniMessage.deserialize((Object)message);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            String controlMode = this.config.getString("control-mode", "combined");
            suggestions.add("toggle");
            suggestions.add("help");
            if (controlMode.equals("separate")) {
                suggestions.add("receive");
            }
            suggestions.add("status");
            if (sender.hasPermission("locatorbar.admin")) {
                suggestions.add("player");
                suggestions.add("reload");
            }
            String input = args[0].toLowerCase();
            suggestions.removeIf(suggestion -> !suggestion.toLowerCase().startsWith(input));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("player") && sender.hasPermission("locatorbar.admin")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                suggestions.add(player.getName());
            }
            String input = args[1].toLowerCase();
            suggestions.removeIf(suggestion -> !suggestion.toLowerCase().startsWith(input));
        } else if (args.length == 3 && args[0].equalsIgnoreCase("player") && sender.hasPermission("locatorbar.admin")) {
            suggestions.addAll(Arrays.asList("toggle", "status"));
            String input = args[2].toLowerCase();
            suggestions.removeIf(suggestion -> !suggestion.toLowerCase().startsWith(input));
        }
        return suggestions;
    }

    public boolean isPlayerVisible(UUID playerUUID) {
        return this.playerVisibility.getOrDefault(playerUUID, true);
    }

    public boolean isPlayerReceiving(UUID playerUUID) {
        return this.playerReceiving.getOrDefault(playerUUID, true);
    }

    public String getPlayerStatus(UUID playerUUID) {
        boolean visible = this.isPlayerVisible(playerUUID);
        boolean receiving = this.isPlayerReceiving(playerUUID);
        if (visible && receiving) {
            return "visible_receiving";
        }
        if (visible && !receiving) {
            return "visible_not_receiving";
        }
        if (!visible && receiving) {
            return "hidden_receiving";
        }
        return "hidden_not_receiving";
    }

    public class LocatorBarPlaceholders
    extends PlaceholderExpansion {
        private final LocatorBar plugin;

        public LocatorBarPlaceholders(LocatorBar this$0, LocatorBar plugin) {
            this.plugin = plugin;
        }

        public boolean persist() {
            return true;
        }

        public boolean canRegister() {
            return true;
        }

        public String getAuthor() {
            return this.plugin.getDescription().getAuthors().toString();
        }

        public String getIdentifier() {
            return "locatorbar";
        }

        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        public String onPlaceholderRequest(Player player, String params) {
            if (player == null) {
                return "";
            }
            UUID uuid = player.getUniqueId();
            switch (params.toLowerCase()) {
                case "visible": {
                    return String.valueOf(this.plugin.isPlayerVisible(uuid));
                }
                case "receiving": {
                    return String.valueOf(this.plugin.isPlayerReceiving(uuid));
                }
                case "status": {
                    return this.plugin.getPlayerStatus(uuid);
                }
            }
            return null;
        }
    }
}

