/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="pmmo", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientTickHandler {
    private static int ticksElapsed = 0;
    public static final List<GainEntry> xpGains = new ArrayList<GainEntry>();

    public static void tickGUI() {
        ++ticksElapsed;
    }

    public static boolean isRefreshTick() {
        return ticksElapsed >= 15;
    }

    public static void resetTicks() {
        ticksElapsed = 0;
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        ++ticksElapsed;
        ClientTickHandler.tickDownGainList();
    }

    public static void tickDownGainList() {
        xpGains.forEach(GainEntry::downTick);
        xpGains.removeIf(entry -> entry.duration <= 0);
    }

    public static void addToGainList(String skill, long amount) {
        SkillData skillData = Config.skills().get(skill);
        if (((List)Config.GAIN_BLACKLIST.get()).contains(skill) || skillData.isSkillGroup() && skillData.getGroup().containsKey(skill)) {
            return;
        }
        if (xpGains.stream().anyMatch(entry -> entry.skill.equals(skill))) {
            GainEntry existingEntry = xpGains.stream().filter(entry -> entry.skill.equals(skill)).findFirst().get();
            xpGains.remove(existingEntry);
            xpGains.add(new GainEntry(skill, existingEntry.value + amount));
        } else {
            xpGains.add(new GainEntry(skill, amount));
        }
    }

    public static class GainEntry {
        public int duration;
        public int color;
        private final String skill;
        private final int skillColor;
        private final long value;

        public GainEntry(String skill, long value) {
            this.skill = skill;
            this.duration = MsLoggy.DEBUG.logAndReturn((Integer)Config.GAIN_LIST_LINGER_DURATION.get(), MsLoggy.LOG_CODE.GUI, "Gain Duration Set as: {}", new Object[0]);
            this.value = value;
            this.skillColor = CoreUtils.getSkillColor(skill);
        }

        public void downTick() {
            --this.duration;
        }

        public Component display() {
            return Component.literal((String)((this.value >= 0L ? "+" : "") + this.value + " ")).append((Component)Component.translatable((String)("pmmo." + this.skill))).setStyle(CoreUtils.getSkillStyle(this.skill));
        }

        public int getColor() {
            this.color = CoreUtils.setTransparency(this.skillColor, (double)this.duration / (double)((Integer)Config.GAIN_LIST_LINGER_DURATION.get()).intValue());
            return this.color;
        }

        public String toString() {
            return "Duration:" + this.duration + "|" + this.display().toString();
        }
    }
}

