/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class VeinRenderer {
    public static void drawBoxHighlights(PoseStack stack, Set<BlockPos> vein) {
        Minecraft mc = Minecraft.getInstance();
        Vec3 cameraPos = mc.getEntityRenderDispatcher().camera.getPosition();
        stack.pushPose();
        stack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(RenderType.lines());
        for (BlockPos pos : vein) {
            VeinRenderer.drawBoxHighlight(stack, builder, pos);
        }
        stack.popPose();
        RenderSystem.disableDepthTest();
        buffer.endBatch();
    }

    public static void drawBoxHighlight(PoseStack stack, VertexConsumer builder, BlockPos pos) {
        stack.pushPose();
        Matrix4f matrix4f = stack.last().pose();
        int red = 255;
        int green = 0;
        int blue = 255;
        int alpha = 255;
        block5: for (int i = 0; i < 12; ++i) {
            int mode = i / 4;
            int j = i % 4;
            float modulus = j % 2;
            float divide = j / 2;
            switch (mode) {
                case 0: {
                    builder.addVertex(matrix4f, (float)pos.getX() + modulus, (float)pos.getY() + divide, (float)pos.getZ()).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 0.0f);
                    builder.addVertex(matrix4f, (float)pos.getX() + modulus, (float)pos.getY() + divide, (float)(pos.getZ() + 1)).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 0.0f);
                    continue block5;
                }
                case 1: {
                    builder.addVertex(matrix4f, (float)pos.getX(), (float)pos.getY() + modulus, (float)pos.getZ() + divide).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 0.0f);
                    builder.addVertex(matrix4f, (float)(pos.getX() + 1), (float)pos.getY() + modulus, (float)pos.getZ() + divide).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 0.0f);
                    continue block5;
                }
                case 2: {
                    builder.addVertex(matrix4f, (float)pos.getX() + divide, (float)pos.getY(), (float)pos.getZ() + modulus).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 0.0f);
                    builder.addVertex(matrix4f, (float)pos.getX() + divide, (float)(pos.getY() + 1), (float)pos.getZ() + modulus).setColor(red, green, blue, alpha).setNormal(0.0f, 0.0f, 0.0f);
                }
            }
        }
        stack.popPose();
    }
}

