/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.compat.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import harmonised.pmmo.compat.ftb_quests.FTBQHandler;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class LevelReward
extends Reward {
    public static RewardType LEVEL_REWARD = FTBQHandler.LEVEL_REWARD;
    public String skill = "mining";
    public long amount = 1L;
    public boolean ignoreBonuses = false;

    public LevelReward(long id, Quest quest) {
        super(id, quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public RewardType getType() {
        return LEVEL_REWARD;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("skill", this.skill);
        nbt.putLong("amount", this.amount);
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.skill = nbt.getString("skill");
        this.amount = nbt.getLong("amount");
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.skill);
        buffer.writeLong(this.amount);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.skill = buffer.readUtf();
        this.amount = buffer.readInt();
    }

    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)"mining", (Object[])Config.skills().skills().keySet().toArray()).create());
        config.addLong("amount", this.amount, input -> {
            this.amount = input;
        }, 1L, -Config.server().levels().maxLevel(), Config.server().levels().maxLevel());
    }

    public void claim(ServerPlayer player, boolean notify) {
        Core.get(player.level()).getData().addLevel(this.skill, player.getUUID(), this.amount);
    }

    public Component getAltTitle() {
        return LangProvider.FTBQ_LVL_TITLE.asComponent(this.amount, LangProvider.skill(this.skill));
    }
}

