/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.compat.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import harmonised.pmmo.compat.ftb_quests.FTBQHandler;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.setup.datagen.LangProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class SkillTask
extends Task {
    public static TaskType SKILL = FTBQHandler.SKILL;
    public String skill = "mining";
    public long requiredLevel = 1L;

    public SkillTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return SKILL;
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("skill", this.skill);
        nbt.putLong("requiredLevel", this.requiredLevel);
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.skill = nbt.getString("skill");
        this.requiredLevel = nbt.getLong("requiredLevel");
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.skill, Short.MAX_VALUE);
        buffer.writeLong(this.requiredLevel);
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.skill = buffer.readUtf(Short.MAX_VALUE);
        this.requiredLevel = buffer.readLong();
    }

    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)"mining", (Object[])Config.skills().skills().keySet().toArray()).create());
        config.addLong("requiredLevel", this.requiredLevel, input -> {
            this.requiredLevel = input;
        }, this.requiredLevel, 1L, Config.server().levels().maxLevel());
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (teamData.isCompleted((QuestObject)this)) {
            return;
        }
        IDataStorage data = Core.get(player.level()).getData();
        long xp = data.getLevel(this.skill, player.getUUID());
        SkillData config = Config.skills().get(this.skill);
        if (config.isSkillGroup() && config.getUseTotalLevels()) {
            xp = config.groupedSkills().get().entrySet().stream().map(entry -> (int)((Double)entry.getValue() * (double)data.getLevel((String)entry.getKey(), player.getUUID()))).mapToInt(Integer::intValue).sum();
        }
        teamData.setProgress((Task)this, xp);
    }

    public long getMaxProgress() {
        return this.requiredLevel;
    }

    public Component getAltTitle() {
        return LangProvider.FTBQ_SKILL_TITLE.asComponent(this.requiredLevel, LangProvider.skill(this.skill));
    }
}

