/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.util.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;

public record PlayerData(boolean override, boolean ignoreReq, Map<String, Double> bonuses) implements DataSource<PlayerData>
{
    public static final MapCodec<PlayerData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("override").forGetter(pd -> Optional.of(pd.override())), (App)Codec.BOOL.optionalFieldOf("ignoreReq").forGetter(pd -> Optional.of(pd.ignoreReq())), (App)CodecTypes.DOUBLE_CODEC.optionalFieldOf("bonuses").forGetter(pd -> Optional.of(pd.bonuses()))).apply((Applicative)instance, (override, reqIgnore, bonus) -> new PlayerData(override.orElse(false), reqIgnore.orElse(false), DataSource.clearEmptyValues(bonus.orElse(new HashMap())))));

    public PlayerData() {
        this(false, false, new HashMap<String, Double>());
    }

    @Override
    public Map<String, Double> getBonuses(ModifierDataType type, CompoundTag nbt) {
        return this.bonuses();
    }

    @Override
    public void setBonuses(ModifierDataType type, Map<String, Double> bonuses) {
        this.bonuses().clear();
        this.bonuses().putAll(bonuses);
    }

    @Override
    public PlayerData combine(PlayerData two) {
        AtomicBoolean ignoreReqMerged = new AtomicBoolean(false);
        HashMap<String, Double> mergedBonus = new HashMap<String, Double>();
        BiConsumer<PlayerData, PlayerData> bothOrNeither = (o, t) -> {
            ignoreReqMerged.set(o.ignoreReq() | t.ignoreReq());
            mergedBonus.putAll(o.bonuses());
            t.bonuses().forEach((skill, mod) -> mergedBonus.merge((String)skill, (Double)mod, (o1, t1) -> o1 > t1 ? o1 : t1));
        };
        Functions.biPermutation(this, two, this.override(), two.override(), (o, t) -> {
            ignoreReqMerged.set(o.ignoreReq());
            mergedBonus.putAll(o.bonuses().isEmpty() ? t.bonuses() : o.bonuses());
        }, bothOrNeither, bothOrNeither);
        return new PlayerData(this.override() || two.override(), ignoreReqMerged.get(), mergedBonus);
    }

    @Override
    public boolean isUnconfigured() {
        return this.ignoreReq() && this.bonuses().isEmpty();
    }

    public Map<String, Double> mergeWithPlayerBonuses(Map<String, Double> map) {
        HashMap<String, Double> newMap = new HashMap<String, Double>(map);
        this.bonuses().forEach((string, ratio) -> newMap.merge((String)string, (Double)ratio, (one, two) -> one + two));
        return newMap;
    }
}

