/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.nbt;

import com.mojang.datafixers.util.Pair;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.nbt.BehaviorToPrevious;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.core.nbt.Operator;
import harmonised.pmmo.core.nbt.PathReader;
import harmonised.pmmo.core.nbt.Result;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;

public class NBTUtils {
    private static final Map<Pair<CompoundTag, Set<LogicEntry>>, Map<String, Double>> cache = new HashMap<Pair<CompoundTag, Set<LogicEntry>>, Map<String, Double>>();

    public static Map<String, Long> getExperienceAward(List<LogicEntry> logic, CompoundTag nbt) {
        return NBTUtils.translateToLong(NBTUtils.evaluateEntries(nbt, new LinkedHashSet<LogicEntry>(logic)));
    }

    public static Map<String, Long> getRequirement(List<LogicEntry> logic, CompoundTag nbt) {
        return NBTUtils.translateToLong(NBTUtils.evaluateEntries(nbt, new LinkedHashSet<LogicEntry>(logic)));
    }

    public static Map<String, Double> getBonuses(List<LogicEntry> logic, CompoundTag nbt) {
        return NBTUtils.evaluateEntries(nbt, new LinkedHashSet<LogicEntry>(logic));
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Double> evaluateEntries(CompoundTag nbt, LinkedHashSet<LogicEntry> logic) {
        void var5_8;
        HashMap<String, Double> output = new HashMap<String, Double>();
        if (nbt == null || nbt.isEmpty()) {
            return output;
        }
        if (cache.containsKey(Pair.of((Object)nbt, logic))) {
            return MsLoggy.DEBUG.logAndReturn(cache.get(Pair.of((Object)nbt, logic)), MsLoggy.LOG_CODE.DATA, "NBT Cache Used", new Object[0]);
        }
        ArrayList<LogicTier> logicSequence = new ArrayList<LogicTier>();
        for (LogicEntry logicEntry : logic) {
            logicSequence.add(new LogicTier(logicEntry.behavior(), logicEntry.addCases(), NBTUtils.processCases(logicEntry.cases(), nbt)));
        }
        ArrayList interMap = new ArrayList();
        for (LogicTier logicTier : logicSequence) {
            HashMap<String, Double> combinedMap = new HashMap<String, Double>();
            List<Result> data = logicTier.results;
            boolean isSummative = logicTier.isSummative;
            for (Result r : data) {
                if (r == null || !r.compares()) continue;
                Map<String, Double> value = r.values();
                for (Map.Entry<String, Double> val : value.entrySet()) {
                    combinedMap.merge(val.getKey(), val.getValue(), isSummative ? Double::sum : Double::max);
                }
            }
            interMap.add(combinedMap);
        }
        boolean bl = false;
        while (var5_8 < logicSequence.size()) {
            switch (((LogicTier)logicSequence.get((int)var5_8)).behavior()) {
                case SUB_FROM: {
                    for (Map.Entry value : ((Map)interMap.get((int)var5_8)).entrySet()) {
                        if (output.getOrDefault(value.getKey(), 0.0) - (Double)value.getValue() <= 0.0) {
                            output.remove(value.getKey());
                            continue;
                        }
                        output.merge((String)value.getKey(), (Double)value.getValue(), (oldValue, newValue) -> oldValue - newValue);
                    }
                    break;
                }
                case HIGHEST: {
                    for (Map.Entry value : ((Map)interMap.get((int)var5_8)).entrySet()) {
                        output.merge((String)value.getKey(), (Double)value.getValue(), Double::max);
                    }
                    break;
                }
                case REPLACE: {
                    output.putAll((Map)interMap.get((int)var5_8));
                    break;
                }
                default: {
                    for (Map.Entry value : ((Map)interMap.get((int)var5_8)).entrySet()) {
                        output.merge((String)value.getKey(), (Double)value.getValue(), Double::sum);
                    }
                }
            }
            ++var5_8;
        }
        cache.put((Pair<CompoundTag, Set<LogicEntry>>)Pair.of((Object)nbt, logic), output);
        return output;
    }

    private static List<Result> processCases(List<LogicEntry.Case> cases, CompoundTag nbt) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (LogicEntry.Case caseIterant : cases) {
            for (String path : caseIterant.paths()) {
                for (LogicEntry.Criteria critObj : caseIterant.criteria()) {
                    Map<String, Double> values = critObj.skillMap();
                    Operator operator = critObj.operator();
                    List<String> comparison = PathReader.getNBTValues(NBTUtils.getActualPath(path), nbt);
                    for (String compare : comparison) {
                        if (!operator.equals((Object)Operator.EXISTS)) {
                            for (String comparators : critObj.comparators().orElseGet(ArrayList::new)) {
                                String comparator = NBTUtils.getActualConstant(comparators);
                                results.add(new Result(operator, comparator, compare, values));
                            }
                            continue;
                        }
                        results.add(new Result(operator, "", compare, values));
                    }
                }
            }
        }
        return results;
    }

    private static Map<String, Long> translateToLong(Map<String, Double> src) {
        HashMap<String, Long> output = new HashMap<String, Long>();
        src.forEach((k, v) -> output.put((String)k, v.longValue()));
        return output;
    }

    private static String getActualPath(String key) {
        return key.contains("#") ? Config.globals().paths().getOrDefault(key.replace("#", ""), "") : key;
    }

    private static String getActualConstant(String key) {
        return key.contains("#") ? Config.globals().constants().getOrDefault(key.replace("#", ""), "") : key;
    }

    private record LogicTier(BehaviorToPrevious behavior, boolean isSummative, List<Result> results) {
    }
}

