/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.nbt;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;

public enum Operator implements StringRepresentable
{
    EQUALS,
    GREATER_THAN,
    LESS_THAN,
    GREATER_THAN_OR_EQUAL,
    LESS_THAN_OR_EQUAL,
    EXISTS;

    public static final Codec<Operator> CODEC;
    private static final Map<String, Operator> BY_NAME;

    public static Operator byName(String name) {
        return BY_NAME.get(name);
    }

    public String getSerializedName() {
        return this.name();
    }

    public static Operator create(String name) {
        throw new IllegalStateException("Enum not extended");
    }

    static {
        CODEC = StringRepresentable.fromEnum(Operator::values);
        BY_NAME = Arrays.stream(Operator.values()).collect(Collectors.toMap(Operator::getSerializedName, s -> s));
    }
}

