/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class PerksImpl {
    private static Set<ItemAbility> DIG_ACTIONS = Set.of(ItemAbilities.PICKAXE_DIG, ItemAbilities.AXE_DIG, ItemAbilities.SHOVEL_DIG, ItemAbilities.HOE_DIG, ItemAbilities.SHEARS_DIG, ItemAbilities.SWORD_DIG);
    private static final CompoundTag NONE = new CompoundTag();
    public static final Map<Player, Boolean> breakSpeedEnabled = new HashMap<Player, Boolean>();
    public static Perk BREAK_SPEED = Perk.begin().addConditions((p, t) -> breakSpeedEnabled.getOrDefault(p, true)).addDefaults(PerksImpl.getDefaults()).setStart((player, nbt) -> {
        float speedBonus = PerksImpl.getRatioForTool(player.getMainHandItem(), nbt);
        if (speedBonus == 0.0f) {
            return NONE;
        }
        float existingSpeedModification = nbt.getFloat("speed");
        float speedModification = Math.max(0.0f, (float)nbt.getInt("level") * speedBonus) + existingSpeedModification;
        speedModification = Math.min((float)nbt.getInt("max_boost"), speedModification);
        return TagBuilder.start().withFloat("speed", speedModification).build();
    }).setDescription(LangProvider.PERK_BREAK_SPEED_DESC.asComponent()).setStatus((player, settings) -> {
        ArrayList lines = new ArrayList();
        int skillLevel = settings.getInt("level");
        DIG_ACTIONS.stream().filter(action -> settings.getFloat(action.name()) > 0.0f).forEach(action -> lines.add(LangProvider.PERK_BREAK_SPEED_STATUS_1.asComponent(action.name(), Float.valueOf(settings.getFloat(action.name()) * (float)skillLevel))));
        return lines;
    }).build();
    private static final ResourceLocation ATTRIBUTE_ID = Reference.rl("tame_boost");
    private static final Map<Holder<Attribute>, Double> ANIMAL_ATTRIBUTES = Map.of(Attributes.JUMP_STRENGTH, 0.005, Attributes.MAX_HEALTH, 1.0, Attributes.MOVEMENT_SPEED, 0.01, Attributes.ARMOR, 0.01, Attributes.ATTACK_DAMAGE, 0.01);
    public static final String ANIMAL_ID = "tamed";
    public static final Perk TAME_BOOST = Perk.begin().addDefaults(TagBuilder.start().withString("skill", "taming").withDouble("per_level", 1.0).withDouble("max_boost", Double.MAX_VALUE).build()).setStart((player, nbt) -> {
        if (player.level() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)player.level();
            UUID animalID = nbt.getUUID(ANIMAL_ID);
            LivingEntity animal = (LivingEntity)world.getEntities().get(animalID);
            if (animal == null) {
                return NONE;
            }
            double perLevel = nbt.getDouble("per_level");
            for (Map.Entry<Holder<Attribute>, Double> atr : ANIMAL_ATTRIBUTES.entrySet()) {
                AttributeInstance instance = animal.getAttribute(atr.getKey());
                if (instance == null) continue;
                double boost = Mth.clamp((double)(perLevel * atr.getValue() * (double)nbt.getInt("level")), (double)0.0, (double)nbt.getDouble("max_boost"));
                AttributeModifier modifier = new AttributeModifier(ATTRIBUTE_ID, boost, AttributeModifier.Operation.ADD_VALUE);
                instance.addPermanentModifier(modifier);
            }
        }
        return NONE;
    }).setDescription(LangProvider.PERK_TAME_BOOST_DESC.asComponent()).setStatus((player, settings) -> {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        double perLevel = settings.getDouble("per_level");
        for (Map.Entry<Holder<Attribute>, Double> atr : ANIMAL_ATTRIBUTES.entrySet()) {
            lines.add(LangProvider.PERK_TAME_BOOST_STATUS_1.asComponent(Component.translatable((String)((Attribute)atr.getKey().value()).getDescriptionId()), DP.dpCustom(perLevel * atr.getValue(), 4)));
        }
        return lines;
    }).build();

    private static float getRatioForTool(ItemStack tool, CompoundTag nbt) {
        float ratio = 0.0f;
        for (ItemAbility action : DIG_ACTIONS) {
            if (!tool.canPerformAction(action)) continue;
            ratio += nbt.getFloat(action.name());
        }
        return ratio;
    }

    public static CompoundTag getDefaults() {
        TagBuilder builder = TagBuilder.start();
        builder.withInt("max_boost", Integer.MAX_VALUE);
        for (ItemAbility action : DIG_ACTIONS) {
            builder.withFloat(action.name(), 0.0f);
        }
        return builder.build();
    }
}

