/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.storage.DataAttachmentTypes;
import harmonised.pmmo.util.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.event.level.PistonEvent;

public class PistonHandler {
    public static void handle(PistonEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Level level = (Level)event.getLevel();
        PistonStructureResolver structure = event.getStructureHelper();
        structure.resolve();
        for (BlockPos destroyed : structure.getToDestroy()) {
            LevelChunk levelChunk = level.getChunkAt(destroyed);
            ((Map)levelChunk.getData(DataAttachmentTypes.PLACED_MAP.get())).remove(destroyed);
            levelChunk.setUnsaved(true);
        }
        HashMap<BlockPos, UUID> updateToMap = new HashMap<BlockPos, UUID>();
        for (BlockPos blockPos : structure.getToPush()) {
            LevelChunk oldCK = level.getChunkAt(blockPos);
            Map placedData = (Map)oldCK.getData(DataAttachmentTypes.PLACED_MAP.get());
            UUID currentID = placedData.getOrDefault(blockPos, Reference.NIL);
            if (currentID.equals(Reference.NIL)) continue;
            placedData.remove(blockPos);
            updateToMap.put(blockPos.relative(event.getStructureHelper().getPushDirection()), currentID);
            oldCK.setUnsaved(true);
        }
        for (Map.Entry entry : updateToMap.entrySet()) {
            LevelChunk toCK = level.getChunkAt((BlockPos)entry.getKey());
            ((Map)toCK.getData(DataAttachmentTypes.PLACED_MAP.get())).put((BlockPos)entry.getKey(), (UUID)entry.getValue());
            toCK.setUnsaved(true);
        }
    }
}

